/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableLongBagFactory;

/**
 * ImmutableLongBagFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongBagFactoryImpl implements ImmutableLongBagFactory
{
    public ImmutableLongBag empty()
    {
        return ImmutableLongEmptyBag.INSTANCE;
    }

    public ImmutableLongBag of()
    {
        return this.empty();
    }

    public ImmutableLongBag with()
    {
        return this.empty();
    }

    public ImmutableLongBag of(long one)
    {
        return this.with(one);
    }

    public ImmutableLongBag with(long one)
    {
        return new ImmutableLongSingletonBag(one);
    }

    public ImmutableLongBag of(long... items)
    {
        return this.with(items);
    }

    public ImmutableLongBag with(long... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableLongHashBag.newBagWith(items);
    }

    public ImmutableLongBag ofAll(LongIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableLongBag withAll(LongIterable items)
    {
        if (items instanceof ImmutableLongBag)
        {
            return (ImmutableLongBag) items;
        }
        return this.with(items.toArray());
    }
}
