/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.dialogs;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.dialogs.MultiLineInputDialog;

public class AddBookmarkDialog
extends MultiLineInputDialog {
    private ColorSelector fColorSelector;
    private Scale fAlphaScale;
    private Label fAlphaLabel;
    private int fAlpha = 128;

    public AddBookmarkDialog(Shell parentShell, String initialValue) {
        super(parentShell, Messages.AddBookmarkDialog_Title, Messages.AddBookmarkDialog_Message, initialValue);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite areaComposite = (Composite)super.createDialogArea(parent);
        Composite colorComposite = new Composite(areaComposite, 0);
        RowLayout layout = new RowLayout();
        layout.center = true;
        colorComposite.setLayout((Layout)layout);
        colorComposite.moveBelow((Control)this.getText());
        Label colorLabel = new Label(colorComposite, 0);
        colorLabel.setText(Messages.AddBookmarkDialog_Color);
        this.fColorSelector = new ColorSelector(colorComposite);
        this.fColorSelector.setColorValue(new RGB(255, 0, 0));
        Label alphaLabel = new Label(colorComposite, 0);
        alphaLabel.setText(Messages.AddBookmarkDialog_Alpha);
        this.fAlphaScale = new Scale(colorComposite, 0);
        this.fAlphaScale.setMaximum(255);
        this.fAlphaScale.setSelection(this.fAlpha);
        this.fAlphaScale.setIncrement(1);
        this.fAlphaScale.setPageIncrement(16);
        this.fAlphaScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddBookmarkDialog.this.fAlpha = AddBookmarkDialog.this.fAlphaScale.getSelection();
                AddBookmarkDialog.this.fAlphaLabel.setText(Integer.toString(AddBookmarkDialog.this.fAlpha));
            }
        });
        this.fAlphaLabel = new Label(colorComposite, 0);
        this.fAlphaLabel.setText(Integer.toString(this.fAlpha));
        return areaComposite;
    }

    public RGBA getColorValue() {
        RGB rgb = this.fColorSelector.getColorValue();
        return new RGBA(rgb.red, rgb.green, rgb.blue, this.fAlpha);
    }
}

