/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.pcap.core.tests.analysis;

import org.eclipse.tracecompass.internal.tmf.pcap.core.analysis.StreamListAnalysis;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.TmfPacketStreamBuilder;
import org.eclipse.tracecompass.internal.tmf.pcap.core.protocol.TmfPcapProtocol;
import org.eclipse.tracecompass.internal.tmf.pcap.core.trace.PcapTrace;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class StreamListAnalysisTest {
    @Test
    public void constructorTest() {
        StreamListAnalysis analysis = new StreamListAnalysis();
        analysis.setId("org.eclipse.linuxtools.tmf.pcap.core.analysis.stream");
        TmfPcapProtocol[] tmfPcapProtocolArray = TmfPcapProtocol.values();
        int n = tmfPcapProtocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            TmfPcapProtocol protocol = tmfPcapProtocolArray[n2];
            if (protocol.supportsStream()) {
                Assert.assertNotNull((Object)analysis.getBuilder(protocol));
            }
            ++n2;
        }
        Assert.assertFalse((boolean)analysis.isFinished());
        analysis.dispose();
    }

    @Test
    public void canExecuteTest() throws TmfTraceException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        String path = trace.getPath().toString();
        PcapTrace pcapTrace = new PcapTrace();
        StreamListAnalysis analysis = new StreamListAnalysis();
        analysis.setId("org.eclipse.linuxtools.tmf.pcap.core.analysis.stream");
        pcapTrace.initTrace(null, path, null);
        Assert.assertTrue((boolean)analysis.canExecute((ITmfTrace)pcapTrace));
        analysis.dispose();
        pcapTrace.dispose();
    }

    @Test
    public void executeAnalysisTest() throws TmfAnalysisException, TmfTraceException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        String path = trace.getPath().toString();
        PcapTrace pcapTrace = new PcapTrace();
        StreamListAnalysis analysis = new StreamListAnalysis();
        pcapTrace.initTrace(null, path, null);
        analysis.setId("org.eclipse.linuxtools.tmf.pcap.core.analysis.stream");
        analysis.setTrace((ITmfTrace)pcapTrace);
        analysis.schedule();
        analysis.waitForCompletion();
        TmfPacketStreamBuilder builder = analysis.getBuilder(TmfPcapProtocol.ETHERNET_II);
        if (builder == null) {
            Assert.fail((String)"The PacketStreamBuilder is null!");
            return;
        }
        Assert.assertEquals((long)1L, (long)builder.getNbStreams());
        builder = analysis.getBuilder(TmfPcapProtocol.IPV4);
        if (builder == null) {
            Assert.fail((String)"The PacketStreamBuilder is null!");
            return;
        }
        Assert.assertEquals((long)3L, (long)builder.getNbStreams());
        builder = analysis.getBuilder(TmfPcapProtocol.TCP);
        if (builder == null) {
            Assert.fail((String)"The PacketStreamBuilder is null!");
            return;
        }
        Assert.assertEquals((long)2L, (long)builder.getNbStreams());
        builder = analysis.getBuilder(TmfPcapProtocol.UDP);
        if (builder == null) {
            Assert.fail((String)"The PacketStreamBuilder is null!");
            return;
        }
        Assert.assertEquals((long)1L, (long)builder.getNbStreams());
        analysis.dispose();
        pcapTrace.dispose();
    }
}

