/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.environment.eclipse;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.uri.IURI;
import org.eclipse.wst.common.environment.uri.IURIFilter;
import org.eclipse.wst.common.environment.uri.IURIScheme;
import org.eclipse.wst.common.environment.uri.URIException;
import org.eclipse.wst.common.internal.environment.eclipse.EclipseScheme;
import org.eclipse.wst.common.internal.environment.eclipse.FileResourceUtils;
import org.eclipse.wst.common.internal.environment.eclipse.Messages;
import org.eclipse.wst.common.internal.environment.relative.RelativeURI;

public class EclipseURI
extends RelativeURI {
    private IEnvironment environment_;
    private EclipseScheme scheme_;
    private File file_;

    public EclipseURI(String uri, IEnvironment environment) {
        super(uri);
        this.environment_ = environment;
        this.scheme_ = new EclipseScheme(environment);
        this.file_ = this.getFile();
    }

    @Override
    public String toString() {
        return this.uri_;
    }

    @Override
    public void erase() throws URIException {
        try {
            IResource file = this.getResource();
            if (file != null && file.exists()) {
                if (file instanceof IFile) {
                    FileResourceUtils.deleteFile((IFile)file, this.environment_.getStatusHandler());
                } else if (file instanceof IFolder) {
                    FileResourceUtils.deleteFolder((IFolder)file, this.environment_.getStatusHandler());
                }
            }
        }
        catch (Exception exc) {
            throw new URIException((IStatus)new Status(4, "id", 0, exc.getMessage(), (Throwable)exc), this);
        }
    }

    @Override
    public InputStream getInputStream() throws URIException {
        try {
            IFile file = (IFile)this.getResource();
            if (file != null) {
                return file.getContents();
            }
        }
        catch (Throwable exc) {
            throw new URIException((IStatus)new Status(4, "id", 0, exc.getMessage(), exc), this);
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws URIException {
        IURI parent = this.parent();
        if (!parent.isPresent()) {
            this.parent().touchFolder();
        }
        return this.getOutStream();
    }

    @Override
    public IURIScheme getURIScheme() {
        return this.scheme_;
    }

    @Override
    public boolean isLeaf() {
        boolean result = false;
        try {
            IResource resource = this.getResource();
            if (resource != null && resource.exists() && resource.getType() == 1) {
                result = true;
            }
        }
        catch (URIException uRIException) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean isPresent() {
        boolean result = false;
        try {
            IResource resource = this.getResource();
            if (resource != null && resource.exists()) {
                result = true;
            }
        }
        catch (URIException uRIException) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean isReadable() {
        boolean result = false;
        try {
            IResource resource = this.getResource();
            if (resource != null && resource.isAccessible()) {
                result = true;
            }
        }
        catch (URIException uRIException) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean isRelative() {
        return false;
    }

    @Override
    public boolean isWritable() {
        boolean result = false;
        try {
            IResource resource = this.getResource();
            if (resource != null && resource.isAccessible() && !resource.getResourceAttributes().isReadOnly()) {
                result = true;
            }
        }
        catch (URIException uRIException) {
            result = false;
        }
        return result;
    }

    @Override
    public IURI[] list() throws URIException {
        IResource resource = this.getResource();
        IURI[] uriChildren = new IURI[]{};
        if (resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            try {
                IResource[] children = folder.members();
                uriChildren = new IURI[children.length];
                int index = 0;
                while (index < children.length) {
                    IPath path = children[index].getFullPath();
                    uriChildren[index] = new EclipseURI(this.scheme_.getURLFromPath(path), this.environment_);
                    ++index;
                }
            }
            catch (CoreException coreException) {}
        }
        return uriChildren;
    }

    @Override
    public IURI[] list(IURIFilter uriFilter) throws URIException {
        IResource resource = this.getResource();
        IURI[] result = new IURI[]{};
        if (resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            try {
                IResource[] children = folder.members();
                Vector<EclipseURI> uriChildren = new Vector<EclipseURI>();
                int index = 0;
                while (index < children.length) {
                    IPath path = children[index].getFullPath();
                    EclipseURI uri = new EclipseURI(this.scheme_.getURLFromPath(path), this.environment_);
                    if (uriFilter.accepts(uri)) {
                        uriChildren.add(uri);
                    }
                    ++index;
                }
                result = uriChildren.toArray(new IURI[0]);
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    @Override
    public void rename(IURI newURI) throws URIException {
        if (newURI == null || !(newURI instanceof EclipseURI)) {
            return;
        }
        try {
            EclipseURI newEclipseURI = (EclipseURI)newURI;
            IPath newPath = new Path(this.scheme_.getPathFromPlatformURI(newEclipseURI.uri_)).makeAbsolute();
            IResource resource = this.getResource();
            if (resource != null) {
                resource.move(newPath, true, null);
            }
        }
        catch (CoreException exc) {
            exc.printStackTrace();
            throw new URIException((IStatus)new Status(4, "id", 0, exc.getMessage(), (Throwable)exc));
        }
    }

    @Override
    public void touchFolder() throws URIException {
        IResource resource = this.getResource();
        if (resource != null) {
            if (resource.getType() == 2) {
                IFolder folder = (IFolder)resource;
                try {
                    if (folder.members().length > 0) {
                        throw new URIException((IStatus)new Status(4, "id", 0, NLS.bind((String)Messages.MSG_ERROR_FOLDER_HAS_CHILDREN, (Object)folder.toString()), null), this);
                    }
                }
                catch (CoreException exc) {
                    throw new URIException((IStatus)new Status(4, "id", 0, exc.getMessage(), (Throwable)exc), this);
                }
            }
        } else {
            IPath newPath = new Path(this.scheme_.getPathFromPlatformURI(this.uri_)).makeAbsolute();
            try {
                FileResourceUtils.makeFolderPath(newPath, this.environment_.getStatusHandler());
            }
            catch (CoreException exc) {
                throw new URIException((IStatus)new Status(4, "id", 0, exc.getMessage(), (Throwable)exc), this);
            }
        }
    }

    @Override
    public void touchLeaf() throws URIException {
        IResource resource = this.getResource();
        if (resource == null) {
            IURI parent = this.parent();
            if (!parent.isPresent()) {
                this.parent().touchFolder();
            }
            try {
                this.getOutStream().close();
            }
            catch (IOException exc) {
                throw new URIException((IStatus)new Status(4, "id", 0, exc.getMessage(), (Throwable)exc), this);
            }
        }
    }

    private IResource getResource() throws URIException {
        Path path = new Path(this.scheme_.getPathFromPlatformURI(this.uri_));
        String absolutePathname = path.makeAbsolute().toString();
        return FileResourceUtils.findResource(absolutePathname);
    }

    private OutputStream getOutStream() throws URIException {
        IPath file = new Path(this.scheme_.getPathFromPlatformURI(this.uri_)).makeAbsolute();
        OutputStream stream = null;
        stream = FileResourceUtils.newFileOutputStream(file, this.environment_.getStatusHandler());
        return stream;
    }

    @Override
    public File asFile() {
        return this.file_;
    }

    @Override
    public boolean isAvailableAsFile() {
        return this.file_ != null;
    }

    @Override
    public URL asURL() throws URIException {
        URL url = null;
        try {
            url = new URL(this.uri_);
        }
        catch (MalformedURLException exc) {
            throw new URIException((IStatus)new Status(4, "id", 0, exc.getMessage(), (Throwable)exc), this);
        }
        return url;
    }

    @Override
    public boolean isAvailableAsURL() {
        URL theURL = null;
        try {
            theURL = this.asURL();
        }
        catch (URIException uRIException) {}
        return theURL != null;
    }

    private File getFile() {
        String platformRes = "platform:/resource";
        File result = null;
        if (this.uri_.startsWith(platformRes)) {
            result = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().removeTrailingSeparator().append(this.uri_.substring(platformRes.length(), this.uri_.length())).toString());
        }
        return result;
    }
}

