/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentproperties.ui;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.ui.internal.Logger;

public class ComboList {
    private Combo combo;
    private List list;

    public ComboList(Composite parent, int style) {
        this.combo = new Combo(parent, style);
        this.list = new ArrayList();
    }

    public void add(String key) {
        this.checkError();
        this.combo.add(key);
        this.list.add(key);
    }

    public void add(String key, int index) {
        this.checkError();
        this.combo.add(key, index);
        this.list.add(index, key);
    }

    public void add(String key, String value) {
        this.checkError();
        this.combo.add(key);
        this.list.add(value);
    }

    public void add(String key, String value, int index) {
        this.checkError();
        this.combo.add(key, index);
        this.list.add(index, value);
    }

    public void addFocusListener(FocusListener listener) {
        this.combo.addFocusListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.combo.addModifyListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.combo.addSelectionListener(listener);
    }

    private void checkError() {
        if (!this.isConsistency()) {
            Logger.log(2, "Difference between the number of keys[" + this.combo.getItemCount() + "] and the number of values[" + this.list.size() + "] in ComboList");
        }
    }

    public Point computeSize(int wHint, int hHint) {
        return this.combo.computeSize(wHint, hHint);
    }

    public Map createHashtable() {
        this.checkError();
        Hashtable m = new Hashtable();
        int i = 0;
        while (i < this.list.size()) {
            m.put(this.combo.getItem(i), this.list.get(i));
            ++i;
        }
        return m;
    }

    public void deselect(int i) {
        this.combo.deselect(i);
    }

    public void deselectAll() {
        this.combo.deselectAll();
    }

    public boolean equals(Object obj) {
        return this.combo.equals(obj);
    }

    private void exchangePosition(int i, int j) {
        String tmpKey = this.getItem(i);
        Object tmpValue = this.list.remove(i);
        this.combo.setItem(i, this.getItem(j));
        this.list.add(i, this.list.remove(j - 1));
        this.combo.setItem(j, tmpKey);
        this.list.add(j, tmpValue);
    }

    public boolean existsAsKey(String str) {
        return this.combo.indexOf(str) >= 0;
    }

    public boolean existsAsValue(String str) {
        return this.list.indexOf(str) >= 0;
    }

    public boolean getEnabled() {
        return this.combo.getEnabled();
    }

    public String getItem(int index) {
        return this.combo.getItem(index);
    }

    public int getItemCount() {
        return this.combo.getItemCount();
    }

    public String getKey(String value) {
        if (value == null) {
            return null;
        }
        int index = -1;
        this.checkError();
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get(i).equals(value)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            return this.combo.getItem(index);
        }
        return null;
    }

    public Object getLayoutData() {
        return this.combo.getLayoutData();
    }

    public String getSelectedValue() {
        this.checkError();
        int index = this.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return this.getValue(this.getItem(index));
    }

    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    public String getText() {
        return this.combo.getText();
    }

    public String getValue(String key) {
        if (key == null) {
            return null;
        }
        int index = -1;
        this.checkError();
        int i = 0;
        while (i < this.combo.getItemCount()) {
            if (this.combo.getItem(i).equals(key)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            return (String)this.list.get(index);
        }
        return null;
    }

    public int indexOf(String str) {
        return this.combo.indexOf(str);
    }

    public boolean isConsistency() {
        return this.list.size() == this.combo.getItemCount();
    }

    public void remove(int index) {
        this.checkError();
        this.combo.remove(index);
        this.list.remove(index);
    }

    public void remove(String str) {
        this.checkError();
        this.combo.remove(str);
        this.list.remove(str);
    }

    public void select(int index) {
        this.combo.select(index);
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
    }

    public boolean setFocus() {
        return this.combo.setFocus();
    }

    public void setItem(int index, String str) {
        this.checkError();
        this.combo.setItem(index, str);
        this.list.remove(index);
        this.list.add(index, str);
    }

    public void setItem(String[] strArray) {
        this.checkError();
        this.combo.setItems(strArray);
        int i = 0;
        while (i < strArray.length) {
            this.list.add(strArray[i]);
            ++i;
        }
    }

    public void setLayout(Layout lo) {
        this.combo.setLayout(lo);
    }

    public void setLayoutData(Object layoutData) {
        this.combo.setLayoutData(layoutData);
    }

    public void setSelection(Point point) {
        this.combo.setSelection(point);
    }

    public void setText(String str) {
        this.combo.setText(str);
    }

    public void sortByKey(int offset) {
        if (offset < 0 || offset > this.combo.getItemCount() - 1) {
            return;
        }
        this.checkError();
        int i = offset;
        while (i < this.combo.getItemCount() - 1) {
            int j = i + 1;
            while (j < this.combo.getItemCount()) {
                if (this.getItem(i).compareTo(this.getItem(j)) > 0) {
                    this.exchangePosition(i, j);
                }
                ++j;
            }
            ++i;
        }
    }
}

