/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.trace;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.trace.CTFIOException;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamOutputWriter;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.ctf.core.trace.Metadata;

public class CTFTraceWriter {
    private final @Nullable CTFTrace fInTrace;

    public CTFTraceWriter(@NonNull CTFTrace trace) throws CTFException {
        this.fInTrace = trace;
        Throwable throwable = null;
        Object var3_4 = null;
        try (CTFTraceReader fTraceReader = new CTFTraceReader(this.fInTrace);){
            fTraceReader.populateIndex();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void copyPackets(long startTime, long endTime, String newTracePath) throws CTFException {
        CTFTrace trace = this.fInTrace;
        if (trace != null) {
            long adjustedStart = trace.timestampNanoToCycles(startTime);
            long adjustedEnd = trace.timestampNanoToCycles(endTime);
            File out = new File(newTracePath);
            if (out.exists()) {
                if (!out.isDirectory() || out.listFiles().length != 0) {
                    throw new CTFIOException("Trace segment cannot be created since trace already exists: " + newTracePath);
                }
            } else if (!out.mkdirs()) {
                throw new CTFIOException("Creating trace directory failed: " + newTracePath);
            }
            Metadata metadata = new Metadata(this.fInTrace);
            try {
                metadata.copyTo(out);
            }
            catch (IOException e) {
                throw new CTFIOException("Error copying metadata: " + e.toString(), e);
            }
            for (ICTFStream stream : trace.getStreams()) {
                Set<CTFStreamInput> inputs = stream.getStreamInputs();
                for (CTFStreamInput s : inputs) {
                    CTFStreamOutputWriter streamOutputwriter = new CTFStreamOutputWriter(Objects.requireNonNull(s), out);
                    streamOutputwriter.copyPackets(adjustedStart, adjustedEnd);
                }
            }
        }
    }
}

