/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.config;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.config.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSource;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSourceType;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigParamDescriptor;
import org.eclipse.tracecompass.tmf.core.config.TmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigurationSourceType;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfConfigurationException;

public class XmlConfigurationSource
implements ITmfConfigurationSource {
    private static final ITmfConfigurationSourceType fType;
    private static final String XML_ANALYSIS_TYPE_ID = "org.eclipse.tracecompass.tmf.core.config.xmlsourcetype";
    private static final String NAME;
    private static final String DESCRIPTION;
    private static final String PATH_KEY = "path";
    private static final String PATH_DESCRIPTION;
    private Map<String, ITmfConfiguration> fConfigurations = new ConcurrentHashMap<String, ITmfConfiguration>();

    static {
        NAME = NonNullUtils.nullToEmptyString((Object)Messages.XmlConfigurationSource_Name);
        DESCRIPTION = NonNullUtils.nullToEmptyString((Object)Messages.XmlConfigurationSource_Description);
        PATH_DESCRIPTION = NonNullUtils.nullToEmptyString((Object)Messages.XmlConfigurationSource_PathDescription);
        TmfConfigParamDescriptor.Builder descriptorBuilder = new TmfConfigParamDescriptor.Builder().setKeyName(PATH_KEY).setDescription(PATH_DESCRIPTION);
        fType = new TmfConfigurationSourceType.Builder().setId(XML_ANALYSIS_TYPE_ID).setDescription(DESCRIPTION).setName(NAME).setConfigParamDescriptors((List)ImmutableList.of((Object)descriptorBuilder.build())).build();
    }

    public XmlConfigurationSource() {
        for (Map.Entry<String, File> entry : XmlUtils.listFiles().entrySet()) {
            ITmfConfiguration config = XmlConfigurationSource.createConfiguration(entry.getValue());
            this.fConfigurations.put(config.getId(), config);
        }
    }

    public ITmfConfigurationSourceType getConfigurationSourceType() {
        return fType;
    }

    public ITmfConfiguration create(Map<String, Object> parameters) throws TmfConfigurationException {
        return this.createOrUpdateXml(null, parameters);
    }

    public @Nullable ITmfConfiguration get(String id) {
        return this.fConfigurations.get(id);
    }

    public ITmfConfiguration update(String id, Map<String, Object> parameters) throws TmfConfigurationException {
        ITmfConfiguration config = this.fConfigurations.get(id);
        if (config == null) {
            throw new TmfConfigurationException("No such configuration with ID: " + id);
        }
        return this.createOrUpdateXml(config, parameters);
    }

    public @Nullable ITmfConfiguration remove(String id) {
        if (this.fConfigurations.get(id) == null) {
            return null;
        }
        if (!XmlUtils.listFiles().containsKey(id)) {
            return null;
        }
        XmlUtils.deleteSupplementaryResources(id, null);
        XmlUtils.deleteFiles((Iterable<String>)ImmutableList.of((Object)id));
        XmlUtils.saveFilesStatus();
        XmlAnalysisModuleSource.notifyModuleChange();
        return this.fConfigurations.remove(id);
    }

    public List<ITmfConfiguration> getConfigurations() {
        return ImmutableList.copyOf(this.fConfigurations.values());
    }

    public boolean contains(String id) {
        return this.fConfigurations.containsKey(id);
    }

    public void dispose() {
        this.fConfigurations.clear();
    }

    private static @Nullable File getFile(Map<String, Object> parameters) {
        String path = (String)parameters.get(PATH_KEY);
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    private ITmfConfiguration createOrUpdateXml(@Nullable ITmfConfiguration existingConfig, Map<String, Object> parameters) throws TmfConfigurationException {
        String statusMessage;
        String message;
        File file = XmlConfigurationSource.getFile(parameters);
        if (file == null) {
            throw new TmfConfigurationException("Missing path");
        }
        ITmfConfiguration config = XmlConfigurationSource.createConfiguration(file);
        IStatus status = XmlUtils.xmlValidate(file);
        if (status.isOK()) {
            if (existingConfig == null) {
                status = XmlUtils.addXmlFile(file);
            } else {
                if (!existingConfig.getId().equals(config.getId())) {
                    throw new TmfConfigurationException("File mismatch");
                }
                XmlUtils.updateXmlFile(file);
            }
            if (status.isOK()) {
                XmlAnalysisModuleSource.notifyModuleChange();
                XmlUtils.saveFilesStatus();
                this.fConfigurations.put(config.getId(), config);
                return config;
            }
        }
        String string = message = (statusMessage = status.getMessage()) != null ? statusMessage : "Failed to update xml analysis configuration";
        if (status.getException() != null) {
            throw new TmfConfigurationException(message, status.getException());
        }
        throw new TmfConfigurationException(message);
    }

    private static String getName(String file) {
        return new Path(file).removeFileExtension().toString();
    }

    private static ITmfConfiguration createConfiguration(File file) {
        String id = file.getName();
        String name = XmlConfigurationSource.getName(file.getName());
        String description = NLS.bind((String)Messages.XmlConfigurationSource_ConfigDescription, (Object)name);
        TmfConfiguration.Builder builder = new TmfConfiguration.Builder().setName(name).setId(id).setDescription(description.toString()).setSourceTypeId(XML_ANALYSIS_TYPE_ID);
        return builder.build();
    }
}

