/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.mtl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.trace4cps.analysis.mtl.AtomicProposition;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.mtl.impl.AbstractMTLformula;
import org.eclipse.trace4cps.core.ClaimEventType;

public class DefaultAtomicProposition
extends AbstractMTLformula
implements AtomicProposition {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final ClaimEventType type;

    public DefaultAtomicProposition(String ... properties) {
        this((ClaimEventType)null, properties);
    }

    public DefaultAtomicProposition(ClaimEventType type, String ... properties) {
        super(new MtlFormula[0]);
        this.type = type;
        if (properties != null) {
            int i = 0;
            while (i < properties.length) {
                this.properties.put(properties[i], properties[i + 1]);
                i += 2;
            }
        }
    }

    public DefaultAtomicProposition(Map<String, String> properties) {
        this(null, properties);
    }

    public DefaultAtomicProposition(ClaimEventType type, Map<String, String> properties) {
        super(new MtlFormula[0]);
        this.type = type;
        this.properties.putAll(properties);
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public void setAttribute(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public String getAttributeValue(String key) {
        return this.properties.get(key);
    }

    @Override
    public void clearAttributes() {
        this.properties.clear();
    }

    @Override
    public ClaimEventType getType() {
        return this.type;
    }

    public String toString() {
        if (this.type == null) {
            return "DefaultAtomicProposition [" + this.properties.toString() + "]";
        }
        return "DefaultAtomicProposition [" + this.properties.toString() + ", type=" + String.valueOf((Object)this.type) + "]";
    }
}

