/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.tl.etl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CompOp implements Enumerator
{
    LE(0, "LE", "<="),
    EQ(1, "EQ", "=="),
    GE(2, "GE", ">=");

    public static final int LE_VALUE = 0;
    public static final int EQ_VALUE = 1;
    public static final int GE_VALUE = 2;
    private static final CompOp[] VALUES_ARRAY;
    public static final List<CompOp> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CompOp[]{LE, EQ, GE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CompOp get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompOp result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompOp getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompOp result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompOp get(int value) {
        switch (value) {
            case 0: {
                return LE;
            }
            case 1: {
                return EQ;
            }
            case 2: {
                return GE;
            }
        }
        return null;
    }

    private CompOp(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

