/**
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * generated by Xtext 2.36.0
 */
package org.eclipse.trace4cps.tl.etl.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.eclipse.trace4cps.tl.etl.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.trace4cps.tl.etl.EtlPackage
 * @generated
 */
public class EtlSwitch<T> extends Switch<T>
{
  /**
   * The cached model package
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static EtlPackage modelPackage;

  /**
   * Creates an instance of the switch.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EtlSwitch()
  {
    if (modelPackage == null)
    {
      modelPackage = EtlPackage.eINSTANCE;
    }
  }

  /**
   * Checks whether this is a switch for the given package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param ePackage the package in question.
   * @return whether this is a switch for the given package.
   * @generated
   */
  @Override
  protected boolean isSwitchFor(EPackage ePackage)
  {
    return ePackage == modelPackage;
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  @Override
  protected T doSwitch(int classifierID, EObject theEObject)
  {
    switch (classifierID)
    {
      case EtlPackage.ETL_MODEL:
      {
        EtlModel etlModel = (EtlModel)theEObject;
        T result = caseEtlModel(etlModel);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.TOP_LEVEL_MODEL_ELEMENT:
      {
        TopLevelModelElement topLevelModelElement = (TopLevelModelElement)theEObject;
        T result = caseTopLevelModelElement(topLevelModelElement);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.SIGNAL:
      {
        Signal signal = (Signal)theEObject;
        T result = caseSignal(signal);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.CONV_SPEC:
      {
        ConvSpec convSpec = (ConvSpec)theEObject;
        T result = caseConvSpec(convSpec);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.FORMULA:
      {
        Formula formula = (Formula)theEObject;
        T result = caseFormula(formula);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.STL_AP:
      {
        StlAp stlAp = (StlAp)theEObject;
        T result = caseStlAp(stlAp);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.MTL_AP:
      {
        MtlAp mtlAp = (MtlAp)theEObject;
        T result = caseMtlAp(mtlAp);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.ATTRIBUTE_FILTER:
      {
        AttributeFilter attributeFilter = (AttributeFilter)theEObject;
        T result = caseAttributeFilter(attributeFilter);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.KEY_VAL:
      {
        KeyVal keyVal = (KeyVal)theEObject;
        T result = caseKeyVal(keyVal);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.ID_STRING:
      {
        IdString idString = (IdString)theEObject;
        T result = caseIdString(idString);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.INTERVAL:
      {
        Interval interval = (Interval)theEObject;
        T result = caseInterval(interval);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.INTERVAL_SS:
      {
        IntervalSS intervalSS = (IntervalSS)theEObject;
        T result = caseIntervalSS(intervalSS);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.INTERVAL_SN:
      {
        IntervalSN intervalSN = (IntervalSN)theEObject;
        T result = caseIntervalSN(intervalSN);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.INTERVAL_NS:
      {
        IntervalNS intervalNS = (IntervalNS)theEObject;
        T result = caseIntervalNS(intervalNS);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.INTERVAL_NN:
      {
        IntervalNN intervalNN = (IntervalNN)theEObject;
        T result = caseIntervalNN(intervalNN);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.SIGNAL_DEF:
      {
        SignalDef signalDef = (SignalDef)theEObject;
        T result = caseSignalDef(signalDef);
        if (result == null) result = caseTopLevelModelElement(signalDef);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.DEF:
      {
        Def def = (Def)theEObject;
        T result = caseDef(def);
        if (result == null) result = caseTopLevelModelElement(def);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.CHECK:
      {
        Check check = (Check)theEObject;
        T result = caseCheck(check);
        if (result == null) result = caseTopLevelModelElement(check);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.TRACE_SIGNAL:
      {
        TraceSignal traceSignal = (TraceSignal)theEObject;
        T result = caseTraceSignal(traceSignal);
        if (result == null) result = caseSignal(traceSignal);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.THROUGHPUT_SIGNAL:
      {
        ThroughputSignal throughputSignal = (ThroughputSignal)theEObject;
        T result = caseThroughputSignal(throughputSignal);
        if (result == null) result = caseSignal(throughputSignal);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.LATENCY_SIGNAL:
      {
        LatencySignal latencySignal = (LatencySignal)theEObject;
        T result = caseLatencySignal(latencySignal);
        if (result == null) result = caseSignal(latencySignal);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.WIP_SIGNAL:
      {
        WipSignal wipSignal = (WipSignal)theEObject;
        T result = caseWipSignal(wipSignal);
        if (result == null) result = caseSignal(wipSignal);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.RESOURCE_AMOUNT_SIGNAL:
      {
        ResourceAmountSignal resourceAmountSignal = (ResourceAmountSignal)theEObject;
        T result = caseResourceAmountSignal(resourceAmountSignal);
        if (result == null) result = caseSignal(resourceAmountSignal);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.RESOURCE_CLIENT_SIGNAL:
      {
        ResourceClientSignal resourceClientSignal = (ResourceClientSignal)theEObject;
        T result = caseResourceClientSignal(resourceClientSignal);
        if (result == null) result = caseSignal(resourceClientSignal);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.REFERENCE_FORMULA:
      {
        ReferenceFormula referenceFormula = (ReferenceFormula)theEObject;
        T result = caseReferenceFormula(referenceFormula);
        if (result == null) result = caseFormula(referenceFormula);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.AP_FORMULA:
      {
        ApFormula apFormula = (ApFormula)theEObject;
        T result = caseApFormula(apFormula);
        if (result == null) result = caseFormula(apFormula);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.NOT_FORMULA:
      {
        NotFormula notFormula = (NotFormula)theEObject;
        T result = caseNotFormula(notFormula);
        if (result == null) result = caseFormula(notFormula);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.AND_OR_FORMULA:
      {
        AndOrFormula andOrFormula = (AndOrFormula)theEObject;
        T result = caseAndOrFormula(andOrFormula);
        if (result == null) result = caseFormula(andOrFormula);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.IF_THEN_FORMULA:
      {
        IfThenFormula ifThenFormula = (IfThenFormula)theEObject;
        T result = caseIfThenFormula(ifThenFormula);
        if (result == null) result = caseFormula(ifThenFormula);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.GLOBALLY_UNTIMED_FORMULA:
      {
        GloballyUntimedFormula globallyUntimedFormula = (GloballyUntimedFormula)theEObject;
        T result = caseGloballyUntimedFormula(globallyUntimedFormula);
        if (result == null) result = caseFormula(globallyUntimedFormula);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.GLOBALLY_FORMULA:
      {
        GloballyFormula globallyFormula = (GloballyFormula)theEObject;
        T result = caseGloballyFormula(globallyFormula);
        if (result == null) result = caseFormula(globallyFormula);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.FINALLY_UNTIMED_FORMULA:
      {
        FinallyUntimedFormula finallyUntimedFormula = (FinallyUntimedFormula)theEObject;
        T result = caseFinallyUntimedFormula(finallyUntimedFormula);
        if (result == null) result = caseFormula(finallyUntimedFormula);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.FINALLY_FORMULA:
      {
        FinallyFormula finallyFormula = (FinallyFormula)theEObject;
        T result = caseFinallyFormula(finallyFormula);
        if (result == null) result = caseFormula(finallyFormula);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.UNTIL_UNTIMED_FORMULA:
      {
        UntilUntimedFormula untilUntimedFormula = (UntilUntimedFormula)theEObject;
        T result = caseUntilUntimedFormula(untilUntimedFormula);
        if (result == null) result = caseFormula(untilUntimedFormula);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.UNTIL_FORMULA:
      {
        UntilFormula untilFormula = (UntilFormula)theEObject;
        T result = caseUntilFormula(untilFormula);
        if (result == null) result = caseFormula(untilFormula);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.STL_AP_DERIV:
      {
        StlApDeriv stlApDeriv = (StlApDeriv)theEObject;
        T result = caseStlApDeriv(stlApDeriv);
        if (result == null) result = caseStlAp(stlApDeriv);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.MTL_AP_START:
      {
        MtlApStart mtlApStart = (MtlApStart)theEObject;
        T result = caseMtlApStart(mtlApStart);
        if (result == null) result = caseMtlAp(mtlApStart);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case EtlPackage.MTL_AP_END:
      {
        MtlApEnd mtlApEnd = (MtlApEnd)theEObject;
        T result = caseMtlApEnd(mtlApEnd);
        if (result == null) result = caseMtlAp(mtlApEnd);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      default: return defaultCase(theEObject);
    }
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Model</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Model</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEtlModel(EtlModel object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Top Level Model Element</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Top Level Model Element</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTopLevelModelElement(TopLevelModelElement object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Signal</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Signal</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseSignal(Signal object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Conv Spec</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Conv Spec</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseConvSpec(ConvSpec object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Formula</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Formula</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFormula(Formula object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Stl Ap</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Stl Ap</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseStlAp(StlAp object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Mtl Ap</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Mtl Ap</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseMtlAp(MtlAp object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Attribute Filter</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Attribute Filter</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseAttributeFilter(AttributeFilter object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Key Val</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Key Val</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseKeyVal(KeyVal object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Id String</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Id String</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseIdString(IdString object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Interval</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Interval</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseInterval(Interval object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Interval SS</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Interval SS</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseIntervalSS(IntervalSS object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Interval SN</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Interval SN</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseIntervalSN(IntervalSN object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Interval NS</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Interval NS</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseIntervalNS(IntervalNS object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Interval NN</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Interval NN</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseIntervalNN(IntervalNN object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Signal Def</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Signal Def</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseSignalDef(SignalDef object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Def</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Def</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDef(Def object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Check</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Check</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseCheck(Check object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Trace Signal</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Trace Signal</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTraceSignal(TraceSignal object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Throughput Signal</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Throughput Signal</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseThroughputSignal(ThroughputSignal object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Latency Signal</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Latency Signal</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseLatencySignal(LatencySignal object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Wip Signal</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Wip Signal</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseWipSignal(WipSignal object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Resource Amount Signal</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Resource Amount Signal</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseResourceAmountSignal(ResourceAmountSignal object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Resource Client Signal</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Resource Client Signal</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseResourceClientSignal(ResourceClientSignal object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Reference Formula</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Reference Formula</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseReferenceFormula(ReferenceFormula object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Ap Formula</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Ap Formula</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseApFormula(ApFormula object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Not Formula</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Not Formula</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseNotFormula(NotFormula object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>And Or Formula</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>And Or Formula</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseAndOrFormula(AndOrFormula object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>If Then Formula</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>If Then Formula</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseIfThenFormula(IfThenFormula object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Globally Untimed Formula</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Globally Untimed Formula</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseGloballyUntimedFormula(GloballyUntimedFormula object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Globally Formula</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Globally Formula</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseGloballyFormula(GloballyFormula object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Finally Untimed Formula</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Finally Untimed Formula</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFinallyUntimedFormula(FinallyUntimedFormula object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Finally Formula</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Finally Formula</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFinallyFormula(FinallyFormula object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Until Untimed Formula</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Until Untimed Formula</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseUntilUntimedFormula(UntilUntimedFormula object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Until Formula</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Until Formula</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseUntilFormula(UntilFormula object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Stl Ap Deriv</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Stl Ap Deriv</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseStlApDeriv(StlApDeriv object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Mtl Ap Start</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Mtl Ap Start</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseMtlApStart(MtlApStart object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Mtl Ap End</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Mtl Ap End</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseMtlApEnd(MtlApEnd object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch, but this is the last case anyway.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject)
   * @generated
   */
  @Override
  public T defaultCase(EObject object)
  {
    return null;
  }

} //EtlSwitch
