/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.tree;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.draw2d.examples.tree.PageNode;
import org.eclipse.draw2d.examples.tree.TreeBranch;
import org.eclipse.draw2d.examples.tree.TreeRoot;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;

public class TreeExample
extends AbstractExample {
    private static final String NORMAL_STYLE = "Normal Style";
    private static final String CHILD_2_NAME = "Child 2";
    private static final String CHILD_1_NAME = "Child 1";
    private static final String BASIC_CHILD_NAME = "child";
    boolean animate;
    private TreeRoot root;
    private PageNode selected;

    public static void main(String[] args) {
        new TreeExample().run();
    }

    IFigure createPageNode(String title) {
        final PageNode node = new PageNode(title);
        node.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                TreeExample.this.setSelected(node);
            }

            public void mouseDoubleClicked(MouseEvent me) {
                TreeExample.this.doExpandCollapse();
            }
        });
        return node;
    }

    void doAddChild() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        parent.addBranch(new TreeBranch(this.createPageNode(BASIC_CHILD_NAME), parent.getStyle()));
    }

    void doAlignCenter() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        parent.setAlignment(2);
    }

    void doAlignLeft() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        parent.setAlignment(1);
    }

    void doDeleteChild() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        IFigure contents = parent.getContentsPane();
        if (contents.getChildren().isEmpty()) {
            return;
        }
        contents.remove((IFigure)contents.getChildren().get(contents.getChildren().size() - 1));
    }

    void doExpandCollapse() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        if (parent.getSubtrees().isEmpty()) {
            return;
        }
        if (this.animate) {
            if (parent.isExpanded()) {
                parent.collapse();
            } else {
                parent.expand();
            }
        } else {
            parent.setExpanded(!parent.isExpanded());
        }
    }

    void doStyleHanging() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        parent.setStyle(1);
    }

    void doStyleNormal() {
        if (this.selected == null) {
            return;
        }
        TreeBranch parent = (TreeBranch)this.selected.getParent();
        parent.setStyle(2);
    }

    @Override
    protected IFigure createContents() {
        this.getFigureCanvas().setBackground(ColorConstants.white);
        this.root = new TreeRoot(this.createPageNode("Graph Root"));
        TreeBranch branch = new TreeBranch(this.createPageNode(NORMAL_STYLE));
        this.root.addBranch(branch);
        this.root.addBranch(new TreeBranch(this.createPageNode("Child")));
        branch.addBranch(new TreeBranch(this.createPageNode(CHILD_1_NAME)));
        branch.addBranch(new TreeBranch(this.createPageNode(CHILD_2_NAME)));
        TreeBranch subbranch = new TreeBranch(this.createPageNode("Child 3"));
        branch.addBranch(subbranch);
        subbranch.addBranch(new TreeBranch(this.createPageNode(BASIC_CHILD_NAME)));
        subbranch.addBranch(new TreeBranch(this.createPageNode(BASIC_CHILD_NAME)));
        subbranch.addBranch(new TreeBranch(this.createPageNode(BASIC_CHILD_NAME)));
        branch = new TreeBranch(this.createPageNode(NORMAL_STYLE), 2);
        this.root.addBranch(branch);
        this.root.addBranch(new TreeBranch(this.createPageNode("Child")));
        branch.addBranch(new TreeBranch(this.createPageNode(CHILD_1_NAME), 1));
        subbranch = new TreeBranch(this.createPageNode(CHILD_2_NAME), 1);
        branch.addBranch(subbranch);
        subbranch.addBranch(new TreeBranch(this.createPageNode(BASIC_CHILD_NAME)));
        subbranch.addBranch(new TreeBranch(this.createPageNode(BASIC_CHILD_NAME)));
        branch = new TreeBranch(this.createPageNode(NORMAL_STYLE));
        this.root.addBranch(branch);
        branch.addBranch(new TreeBranch(this.createPageNode(CHILD_1_NAME)));
        branch.addBranch(new TreeBranch(this.createPageNode(CHILD_2_NAME)));
        branch.addBranch(new TreeBranch(this.createPageNode("Child 3")));
        return this.root;
    }

    @Override
    protected void hookShell(Shell shell) {
        Composite localShell = new Composite((Composite)shell, 0);
        localShell.setLayoutData((Object)new GridData(1040));
        localShell.setLayout((Layout)new GridLayout());
        Group rootGroup = new Group(localShell, 0);
        rootGroup.setText("Root Properties");
        FontData data = rootGroup.getFont().getFontData()[0];
        data.setStyle(1);
        rootGroup.setLayout((Layout)new GridLayout());
        Button orientation = new Button((Composite)rootGroup, 32);
        orientation.setText("Horizontal Orientation");
        orientation.setSelection(true);
        orientation.addListener(13, e -> this.root.setHorizontal(orientation.getSelection()));
        Button useAnimation = new Button((Composite)rootGroup, 32);
        useAnimation.setText("Use Animation");
        useAnimation.setSelection(false);
        useAnimation.addListener(13, e -> {
            boolean bl = this.animate = useAnimation.getSelection();
        });
        Button compress = new Button((Composite)rootGroup, 32);
        compress.setText("Compress Tree");
        compress.setSelection(false);
        compress.addListener(13, e -> {
            this.root.setCompression(compress.getSelection());
            this.root.invalidateTree();
            this.root.revalidate();
        });
        Label majorLabel = new Label((Composite)rootGroup, 0);
        majorLabel.setText("Major Spacing: 10");
        Scale major = new Scale((Composite)rootGroup, 0);
        major.setMinimum(5);
        major.setIncrement(5);
        major.setMaximum(50);
        major.setSelection(10);
        major.addListener(13, e -> {
            this.root.setMajorSpacing(major.getSelection());
            majorLabel.setText("Major Spacing: " + this.root.getMajorSpacing());
        });
        Label minorLabel = new Label((Composite)rootGroup, 0);
        minorLabel.setText("Minor Spacing: 10");
        Scale minor = new Scale((Composite)rootGroup, 0);
        minor.setMinimum(5);
        minor.setIncrement(5);
        minor.setMaximum(50);
        minor.setSelection(10);
        minor.addListener(13, e -> {
            this.root.setMinorSpacing(minor.getSelection());
            minorLabel.setText("Minor Spacing: " + this.root.getMinorSpacing());
        });
        Group selectedGroup = new Group(localShell, 0);
        selectedGroup.setText("Selected Node:");
        selectedGroup.setLayout((Layout)new GridLayout(2, true));
        Button addChild = new Button((Composite)selectedGroup, 0);
        addChild.setText("More Children");
        addChild.addListener(13, e -> this.doAddChild());
        Button removeChild = new Button((Composite)selectedGroup, 0);
        removeChild.setText("Fewer Children");
        removeChild.addListener(13, e -> this.doDeleteChild());
        Button alignCenter = new Button((Composite)selectedGroup, 0);
        alignCenter.setText("Align Center");
        alignCenter.addListener(13, e -> this.doAlignCenter());
        Button alignLeft = new Button((Composite)selectedGroup, 0);
        alignLeft.setText("Align Top/Left");
        alignLeft.addListener(13, e -> this.doAlignLeft());
        Button normal = new Button((Composite)selectedGroup, 0);
        normal.setText("Normal");
        normal.addListener(13, e -> this.doStyleNormal());
        Button hanging = new Button((Composite)selectedGroup, 0);
        hanging.setText("Hanging");
        hanging.addListener(13, e -> this.doStyleHanging());
        Button expandCollapse = new Button((Composite)selectedGroup, 0);
        expandCollapse.setText("expand/collapse");
        expandCollapse.addListener(13, e -> this.doExpandCollapse());
    }

    void setSelected(PageNode node) {
        if (this.selected != null) {
            this.selected.setSelected(false);
        }
        this.selected = node;
        this.selected.setSelected(true);
    }
}

