/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.swt;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ShapeStylesExample {
    static StyleAxis[] styleAxes = new StyleAxis[]{new StyleAxis("Line Width", new StyleItem[]{new StyleItem(0.0f), new StyleItem(0.25f), new StyleItem(0.5f), new StyleItem(1.0f), new StyleItem(2.5f), new StyleItem(5.0f), new StyleItem(10.0f)}){

        @Override
        public void applyTo(Shape shape, int i) {
            shape.setLineWidthFloat(this.elements[i].getValue());
        }
    }, new StyleAxis("Line Style", new StyleItem[]{new StyleItem("SWT.LINE_SOLID", 1.0f), new StyleItem("SWT.LINE_DASH", 2.0f), new StyleItem("SWT.LINE_DASHDOT", 4.0f), new StyleItem("SWT.LINE_DASHDOTDOT", 5.0f), new StyleItem("SWT.LINE_DOT", 3.0f)}){

        @Override
        public void applyTo(Shape shape, int i) {
            shape.setLineStyle((int)this.elements[i].getValue());
        }
    }, new StyleAxis("Line Cap", new StyleItem[]{new StyleItem("SWT.CAP_FLAT", 1.0f), new StyleItem("SWT.CAP_ROUND", 2.0f), new StyleItem("SWT.CAP_SQUARE", 3.0f)}){

        @Override
        public void applyTo(Shape shape, int i) {
            shape.setLineCap((int)this.elements[i].getValue());
        }
    }, new StyleAxis("Line Miter Limit", new StyleItem[]{new StyleItem(0.0f), new StyleItem(0.5f), new StyleItem(1.0f), new StyleItem(2.0f), new StyleItem(5.0f), new StyleItem(10.0f), new StyleItem(50.0f)}){

        @Override
        public void applyTo(Shape shape, int i) {
            shape.setLineMiterLimit(this.elements[i].getValue());
        }
    }, new StyleAxis("Line Dash Offset", new StyleItem[]{new StyleItem(0.0f), new StyleItem(0.25f), new StyleItem(0.5f), new StyleItem(1.0f), new StyleItem(2.0f), new StyleItem(2.5f), new StyleItem(5.0f), new StyleItem(10.0f)}){

        @Override
        public void applyTo(Shape shape, int i) {
            shape.setLineDashOffset(this.elements[i].getValue());
        }
    }, new StyleAxis("Anti-Aliasing", new StyleItem[]{new StyleItem("SWT.ON", 1.0f), new StyleItem("SWT.OFF", 0.0f), new StyleItem("SWT.DEFAULT", -1.0f)}){

        @Override
        public void applyTo(Shape shape, int i) {
            shape.setAntialias((int)this.elements[i].getValue());
        }
    }, new StyleAxis("Alpha", new StyleItem[]{new StyleItem(0.0f), new StyleItem(10.0f), new StyleItem(50.0f), new StyleItem(100.0f), new StyleItem(150.0f), new StyleItem(200.0f), new StyleItem(255.0f)}){

        @Override
        public void applyTo(Shape shape, int i) {
            shape.setAlpha((int)this.elements[i].getValue());
        }
    }, new StyleAxis("Enabled", new StyleItem[]{new StyleItem("true", 1.0f), new StyleItem("false", 0.0f)}){

        @Override
        public void applyTo(Shape shape, int i) {
            int setting = (int)this.elements[i].getValue();
            shape.setEnabled(setting == 1);
        }
    }};
    static final String[] sampleShapeClasses = new String[]{Ellipse.class.getName(), RectangleFigure.class.getName(), RoundedRectangle.class.getName(), Triangle.class.getName(), Polyline.class.getName()};
    static final String[] defaultLineWidths = new String[]{"0", "0.5", "1", "2.5", "5", "10", "30"};
    private static Shell shell;
    private static Group styleGrid;
    private static StyleAxis xAxis;
    private static StyleAxis yAxis;
    private static float defaultLineWidth;
    private static Class sampleShape;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        display = Display.getDefault();
        ShapeStylesExample.shell = new Shell(display, 1264);
        ShapeStylesExample.shell.setText("Shape Style Example");
        ShapeStylesExample.shell.setLayout((Layout)new GridLayout(2, false));
        controlPane = new Group((Composite)ShapeStylesExample.shell, 0);
        controlPane.setText("Style Axis Settings");
        controlPane.setLayout((Layout)new GridLayout(2, false));
        controlPane.setLayoutData((Object)new GridData(0x1000000, 128, true, true, 1, 1));
        xAxisSelectionLabel = new Label((Composite)controlPane, 0);
        xAxisSelectionLabel.setText("X Axis");
        xAxisSelection = new Combo((Composite)controlPane, 8);
        var8_5 = ShapeStylesExample.styleAxes;
        var7_8 = ShapeStylesExample.styleAxes.length;
        var6_11 = 0;
        while (var6_11 < var7_8) {
            element = var8_5[var6_11];
            xAxisSelection.add(element.getName());
            ++var6_11;
        }
        xAxisSelection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                xAxis = styleAxes[xAxisSelection.getSelectionIndex()];
                ShapeStylesExample.refreshGrid();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        yAxisSelectionLabel = new Label((Composite)controlPane, 0);
        yAxisSelectionLabel.setText("Y Axis");
        yAxisSelection = new Combo((Composite)controlPane, 8);
        var10_14 = ShapeStylesExample.styleAxes;
        var9_15 = ShapeStylesExample.styleAxes.length;
        var8_6 = 0;
        while (var8_6 < var9_15) {
            element = var10_14[var8_6];
            yAxisSelection.add(element.getName());
            ++var8_6;
        }
        yAxisSelection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                yAxis = styleAxes[yAxisSelection.getSelectionIndex()];
                ShapeStylesExample.refreshGrid();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        shapeSelectionLabel = new Label((Composite)controlPane, 0);
        shapeSelectionLabel.setText("Shape");
        shapeSelection = new Combo((Composite)controlPane, 0);
        shapeSelection.setItems(ShapeStylesExample.sampleShapeClasses);
        shapeSelection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    sampleShape = Class.forName(shapeSelection.getText());
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                }
                ShapeStylesExample.refreshGrid();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        lineWidthSelectionLabel = new Label((Composite)controlPane, 0);
        lineWidthSelectionLabel.setText("Line Width");
        lineWidthSelection = new Combo((Composite)controlPane, 0);
        lineWidthSelection.setItems(ShapeStylesExample.defaultLineWidths);
        lineWidthSelection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                defaultLineWidth = Float.parseFloat(lineWidthSelection.getText());
                ShapeStylesExample.refreshGrid();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        ShapeStylesExample.xAxis = ShapeStylesExample.styleAxes[0];
        ShapeStylesExample.yAxis = ShapeStylesExample.styleAxes[1];
        ShapeStylesExample.defaultLineWidth = Float.parseFloat(ShapeStylesExample.defaultLineWidths[4]);
        try {
            ShapeStylesExample.sampleShape = Class.forName(ShapeStylesExample.sampleShapeClasses[0]);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        xAxisSelection.select(0);
        yAxisSelection.select(1);
        lineWidthSelection.select(4);
        shapeSelection.select(0);
        ShapeStylesExample.refreshGrid();
        ShapeStylesExample.shell.open();
        ** GOTO lbl62
        {
            display.sleep();
            do {
                if (!display.readAndDispatch()) continue block4;
lbl62:
                // 2 sources

            } while (!ShapeStylesExample.shell.isDisposed());
        }
    }

    static void refreshGrid() {
        if (styleGrid != null) {
            styleGrid.dispose();
            shell.pack();
        }
        styleGrid = new Group((Composite)shell, 0);
        styleGrid.setText(xAxis.getName() + " vs. " + yAxis.getName());
        styleGrid.setLayout((Layout)new GridLayout(xAxis.getCount() + 1, false));
        styleGrid.setLayoutData((Object)new GridData(16384, 128, true, true, 1, 1));
        Label label = new Label((Composite)styleGrid, 0);
        int x = 0;
        while (x < xAxis.getCount()) {
            label = new Label((Composite)styleGrid, 0);
            label.setText(xAxis.getName() + " =\n" + xAxis.getAt(x).getName());
            ++x;
        }
        int y = 1;
        while (y < yAxis.getCount() + 1) {
            label = new Label((Composite)styleGrid, 0);
            label.setText(yAxis.getName() + " =\n" + yAxis.getAt(y - 1).getName());
            int x2 = 1;
            while (x2 < xAxis.getCount() + 1) {
                Shape shape;
                if (sampleShape == Polyline.class) {
                    Polyline poly = new Polyline();
                    poly.addPoint(new Point(20, 20));
                    poly.addPoint(new Point(50, 80));
                    poly.addPoint(new Point(10, 50));
                    shape = poly;
                } else {
                    try {
                        shape = (Shape)sampleShape.getConstructor(null).newInstance(null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not find a no args constructor for " + sampleShape.getName());
                    }
                    shape.setBounds(new Rectangle(0, 0, 100, 75));
                }
                shape.setBackgroundColor(ColorConstants.orange);
                shape.setLineWidthFloat(defaultLineWidth);
                shape.setAntialias(1);
                xAxis.applyTo(shape, x2 - 1);
                yAxis.applyTo(shape, y - 1);
                FigureCanvas figureBox = new FigureCanvas((Composite)styleGrid);
                figureBox.setContents((IFigure)shape);
                ++x2;
            }
            ++y;
        }
        shell.pack();
    }

    static abstract class StyleAxis {
        private final String name;
        protected StyleItem[] elements;

        protected StyleAxis(String name, StyleItem[] elements) {
            this.name = name;
            this.elements = elements;
        }

        public int getCount() {
            return this.elements.length;
        }

        public StyleItem getAt(int i) {
            return this.elements[i];
        }

        public String getName() {
            return this.name;
        }

        public abstract void applyTo(Shape var1, int var2);
    }

    static class StyleItem {
        private final String name;
        private final float value;

        public StyleItem(float value) {
            this.name = Float.toString(value);
            this.value = value;
        }

        public StyleItem(String name, float value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public float getValue() {
            return this.value;
        }
    }
}

