/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.model.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.flow.model.Activity;
import org.eclipse.gef.examples.flow.model.Transition;

public class ConnectionCreateCommand
extends Command {
    protected Transition transition;
    protected Activity source;
    protected Activity target;

    public boolean canExecute() {
        if (this.source.equals(this.target)) {
            return false;
        }
        return this.source.getOutgoingTransitions().stream().noneMatch(t -> t.target.equals(this.target));
    }

    public void execute() {
        this.transition = new Transition(this.source, this.target);
    }

    public Activity getSource() {
        return this.source;
    }

    public Activity getTarget() {
        return this.target;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public void redo() {
        this.source.addOutput(this.transition);
        this.target.addInput(this.transition);
    }

    public void setSource(Activity activity) {
        this.source = activity;
    }

    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public void setTarget(Activity activity) {
        this.target = activity;
    }

    public void undo() {
        this.source.removeOutput(this.transition);
        this.target.removeInput(this.transition);
    }
}

