/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.semantictokens;

import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

public enum TokenType {
    NAMESPACE("namespace"),
    CLASS("class"),
    INTERFACE("interface"),
    ENUM("enum"),
    ENUM_MEMBER("enumMember"),
    TYPE("type"),
    TYPE_PARAMETER("typeParameter"),
    METHOD("method"),
    PROPERTY("property"),
    VARIABLE("variable"),
    PARAMETER("parameter"),
    MODIFIER("modifier"),
    KEYWORD("keyword"),
    ANNOTATION("annotation"),
    ANNOTATION_MEMBER("annotationMember"),
    RECORD("record"),
    RECORD_COMPONENT("recordComponent");

    private String genericName;

    private TokenType(String genericName) {
        this.genericName = genericName;
    }

    public String toString() {
        return this.genericName;
    }

    public static TokenType getApplicableType(IBinding binding) {
        if (binding == null) {
            return null;
        }
        switch (binding.getKind()) {
            case 3: {
                IVariableBinding variableBinding = (IVariableBinding)binding;
                if (variableBinding.isEnumConstant()) {
                    return ENUM_MEMBER;
                }
                if (variableBinding.isRecordComponent()) {
                    return RECORD_COMPONENT;
                }
                if (variableBinding.isField()) {
                    return PROPERTY;
                }
                if (variableBinding.isParameter()) {
                    return PARAMETER;
                }
                return VARIABLE;
            }
            case 4: {
                IMethodBinding methodBinding = (IMethodBinding)binding;
                if (methodBinding.isConstructor()) {
                    return TokenType.getApplicableType((IBinding)methodBinding.getDeclaringClass());
                }
                if (methodBinding.isAnnotationMember()) {
                    return ANNOTATION_MEMBER;
                }
                return METHOD;
            }
            case 2: {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.isTypeVariable()) {
                    return TYPE_PARAMETER;
                }
                if (typeBinding.isAnnotation()) {
                    return ANNOTATION;
                }
                if (typeBinding.isRecord()) {
                    return RECORD;
                }
                if (typeBinding.isInterface()) {
                    return INTERFACE;
                }
                if (typeBinding.isEnum()) {
                    return ENUM;
                }
                if (typeBinding.isClass()) {
                    return CLASS;
                }
                return TYPE;
            }
            case 1: 
            case 7: {
                return NAMESPACE;
            }
        }
        return null;
    }
}

