/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.internal.codeassist.impl.Engine;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalReplacementProvider;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalRequestor;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalUtils;
import org.eclipse.jdt.ls.core.internal.contentassist.SnippetCompletionProposal;
import org.eclipse.jdt.ls.core.internal.contentassist.SnippetUtils;
import org.eclipse.jdt.ls.core.internal.corext.template.java.PostfixCompletionProposal;
import org.eclipse.jdt.ls.core.internal.corext.template.java.PostfixTemplateEngine;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionGuessMethodArgumentsMode;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.jdt.ls.core.internal.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.osgi.util.NLS;

public class CompletionResolveHandler {
    public static final String EMPTY_STRING = "";
    public static final String DEFAULT = "Default: ";
    private static final String VALUE = "Value: ";
    private final PreferenceManager manager;
    public static final String DATA_FIELD_URI = "uri";
    public static final String DATA_FIELD_REQUEST_ID = "rid";
    public static final String DATA_FIELD_PROPOSAL_ID = "pid";

    public CompletionResolveHandler(PreferenceManager manager) {
        this.manager = manager;
    }

    /*
     * Unable to fully structure code
     */
    public CompletionItem resolve(CompletionItem param, IProgressMonitor monitor) {
        data = JSONUtility.toModel(param.getData(), Map.class);
        param.setData(null);
        if (!(CompletionProposalRequestor.SUPPORTED_KINDS.contains(param.getKind()) && data != null && data.containsKey("rid") && data.containsKey("pid"))) {
            return param;
        }
        proposalId = Integer.parseInt((String)data.get("pid"));
        requestId = Long.parseLong((String)data.get("rid"));
        completionResponse = CompletionResponses.get(requestId);
        if (completionResponse == null || completionResponse.getProposals().size() <= proposalId) {
            throw new IllegalStateException("Invalid completion proposal");
        }
        uri = completionResponse.getCommonData("uri");
        unit = JDTUtils.resolveCompilationUnit(uri);
        if (unit == null) {
            throw new IllegalStateException(NLS.bind((String)"Unable to match Compilation Unit from {0} ", (Object)uri));
        }
        if (monitor.isCanceled()) {
            param.setData(null);
            return param;
        }
        proposal = completionResponse.getProposals().get(proposalId);
        if (param.getKind() == CompletionItemKind.Snippet) {
            try {
                ctx = completionResponse.getContext();
                if (proposal instanceof SnippetCompletionProposal) {
                    template = ((SnippetCompletionProposal)proposal).getTemplate();
                    content = SnippetCompletionProposal.evaluateGenericTemplate(unit, ctx, template);
                    if (this.manager.getClientPreferences().isCompletionResolveDocumentSupport()) {
                        param.setDocumentation(SnippetUtils.beautifyDocument(content));
                    }
                    if (this.manager.getPreferences().isCompletionLazyResolveTextEditEnabled()) {
                        SnippetCompletionProposal.setTextEdit(ctx, unit, param, content);
                    }
                } else if (proposal instanceof PostfixCompletionProposal) {
                    postfixContext = ((PostfixCompletionProposal)proposal).getContext();
                    template = ((PostfixCompletionProposal)proposal).getTemplate();
                    postfixContext.setActiveTemplateName(template.getName());
                    content = PostfixTemplateEngine.evaluateGenericTemplate(postfixContext, template);
                    length = postfixContext.getEnd() - postfixContext.getStart();
                    range = JDTUtils.toRange((IOpenable)unit, postfixContext.getStart(), length);
                    if (this.manager.getPreferences().isCompletionLazyResolveTextEditEnabled()) {
                        textEdit = new TextEdit(range, content);
                        param.setTextEdit(Either.forLeft((Object)textEdit));
                    }
                    if (this.manager.getClientPreferences().isCompletionResolveDocumentSupport()) {
                        param.setDocumentation(SnippetUtils.beautifyDocument(content));
                    }
                    if (this.manager.getClientPreferences().isCompletionResolveDocumentSupport()) {
                        param.setDetail(template.getDescription());
                    }
                    if (this.manager.getClientPreferences().isResolveAdditionalTextEditsSupport()) {
                        PostfixTemplateEngine.setAdditionalTextEdit(param, unit, postfixContext, range, template);
                    }
                }
                param.setData(null);
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            return param;
        }
        if (this.manager.getClientPreferences().isResolveAdditionalTextEditsSupport()) {
            proposalProvider = new CompletionProposalReplacementProvider(unit, completionResponse.getContext(), completionResponse.getOffset(), this.manager.getPreferences(), this.manager.getClientPreferences(), true);
            proposalProvider.updateReplacement(proposal, param, '\u0000');
        }
        if (!this.manager.getClientPreferences().isCompletionResolveDocumentSupport()) {
            return param;
        }
        if ((this.manager.getPreferences().getGuessMethodArgumentsMode() == CompletionGuessMethodArgumentsMode.OFF || JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isCollapseCompletionItemsEnabled()) && (requiredTypeProposal = CompletionProposalUtils.getRequiredTypeProposal(proposal)) != null) {
            proposal = requiredTypeProposal;
        }
        member = null;
        if (proposal.getKind() == 9) {
            signature = proposal.getSignature();
            if (signature != null) {
                typeName = SignatureUtil.stripSignatureToFQN((String)String.valueOf(signature));
                try {
                    type = unit.getJavaProject().findType(typeName);
                    if (type == null) ** GOTO lbl116
                    member = type;
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    return param;
                }
            }
        } else {
            declarationSignature = proposal.getDeclarationSignature();
            if (declarationSignature != null) {
                typeName = String.valueOf(declarationSignature);
                try {
                    typeName = SignatureUtil.stripSignatureToFQN((String)typeName);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                try {
                    type = unit.getJavaProject().findType(typeName);
                    if (type != null && proposal.getName() != null) {
                        paramSigs = CharOperation.NO_STRINGS;
                        textEdit = proposal;
                        if (textEdit instanceof InternalCompletionProposal) {
                            range = (InternalCompletionProposal)textEdit;
                            (InternalCompletionProposal)textEdit;
                            var20_35 = binding = internalProposal.getBinding();
                            if (var20_35 instanceof MethodBinding) {
                                var19_36 = (MethodBinding)var20_35;
                                (MethodBinding)var20_35;
                                original = methodBinding.original();
                                signature = original != binding ? Engine.getSignature((MethodBinding)original) : Engine.getSignature((MethodBinding)methodBinding);
                                parameters = Signature.getParameterTypes((String)String.valueOf(SignatureUtil.fix83600((char[])signature)));
                                i = 0;
                                while (i < parameters.length) {
                                    parameters[i] = SignatureUtil.getLowerBound((String)parameters[i]);
                                    ++i;
                                }
                                paramSigs = parameters;
                            }
                        }
                        if ((methods = type.findMethods(method = type.getMethod(name = String.valueOf(proposal.getName()), paramSigs))) != null && methods.length > 0) {
                            method = methods[0];
                        }
                        if (method.exists()) {
                            member = method;
                        } else {
                            field = type.getField(name);
                            if (field.exists()) {
                                member = field;
                            }
                        }
                    }
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    return param;
                }
            }
        }
lbl116:
        // 7 sources

        if (member != null && member.exists() && !monitor.isCanceled()) {
            javadoc = null;
            try {
                curMember = member;
                javadoc = (String)SimpleTimeLimiter.create((ExecutorService)JavaLanguageServerPlugin.getExecutorService()).callWithTimeout((Callable<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$0(org.eclipse.jdt.core.IMember ), ()Ljava/lang/String;)((CompletionResolveHandler)this, (IMember)curMember), 500L, TimeUnit.MILLISECONDS);
            }
            catch (UncheckedTimeoutException | TimeoutException tooSlow) {
                return param;
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException("Unable to read documentation", e);
                return param;
            }
            constantValue = null;
            if (proposal.getKind() == 2) {
                try {
                    field = JDTUtils.resolveField(proposal, unit.getJavaProject());
                    nameRegion = null;
                    if (field != null) {
                        typeRoot = field.getTypeRoot();
                        nameRange = field.getNameRange();
                        if (SourceRange.isAvailable((ISourceRange)nameRange)) {
                            nameRegion = new Region(nameRange.getOffset(), nameRange.getLength());
                        }
                        constantValue = JDTUtils.getConstantValue(field, typeRoot, nameRegion);
                    }
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.log((CoreException)e);
                    return param;
                }
            }
            if (constantValue != null) {
                javadoc = this.manager.getClientPreferences().isSupportsCompletionDocumentationMarkdown() != false ? (String)(javadoc == null ? "" : javadoc) + "\n\nValue: " + constantValue : (String)(javadoc == null ? "" : javadoc) + "Value: " + constantValue;
            }
            defaultValue = null;
            if (proposal.getKind() == 6 || proposal.getKind() == 13) {
                try {
                    method = JDTUtils.resolveMethod(proposal, unit.getJavaProject());
                    nameRegion = null;
                    if (method != null) {
                        typeRoot = method.getTypeRoot();
                        nameRange = method.getNameRange();
                        if (SourceRange.isAvailable((ISourceRange)nameRange)) {
                            nameRegion = new Region(nameRange.getOffset(), nameRange.getLength());
                        }
                        defaultValue = JDTUtils.getAnnotationMemberDefaultValue(method, typeRoot, nameRegion);
                    }
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.log((CoreException)e);
                    return param;
                }
            }
            if (defaultValue != null) {
                javadoc = this.manager.getClientPreferences().isSupportsCompletionDocumentationMarkdown() != false ? (String)(javadoc == null ? "" : javadoc) + "\n\nDefault: " + defaultValue : (String)(javadoc == null ? "" : javadoc) + "Default: " + defaultValue;
            }
            if (javadoc != null) {
                if (this.manager.getClientPreferences().isSupportsCompletionDocumentationMarkdown()) {
                    markupContent = new MarkupContent();
                    markupContent.setKind("markdown");
                    markupContent.setValue((String)javadoc);
                    param.setDocumentation(markupContent);
                } else {
                    param.setDocumentation((String)javadoc);
                }
            }
        }
        return param;
    }

    private /* synthetic */ String lambda$0(IMember iMember) throws Exception {
        Reader reader = this.manager.getClientPreferences().isSupportsCompletionDocumentationMarkdown() ? JavadocContentAccess2.getMarkdownContentReader((IJavaElement)iMember) : JavadocContentAccess2.getPlainTextContentReader(iMember);
        return reader == null ? null : CharStreams.toString((Readable)reader);
    }
}

