/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.cleanup;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.cleanup.ISimpleCleanUp;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.text.edits.TextEdit;

public class CleanUpUtils {
    public static CleanUpContextCore getCleanUpContext(TextDocumentIdentifier textDocumentId, Map<String, String> compilerOpts, IProgressMonitor monitor) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(textDocumentId.getUri());
        return CleanUpUtils.getCleanUpContext(unit, compilerOpts, monitor);
    }

    public static CleanUpContextCore getCleanUpContext(ICompilationUnit unit, Map<String, String> compilerOpts, IProgressMonitor monitor) {
        CompilationUnit ast = CleanUpUtils.createASTWithOpts(unit, compilerOpts, monitor);
        return new CleanUpContextCore(unit, ast);
    }

    public static TextEdit getTextEditFromCleanUp(ISimpleCleanUp cleanUp, CleanUpContextCore context, IProgressMonitor monitor) {
        ICleanUpFixCore fix;
        block3: {
            try {
                ICleanUpFixCore iCleanUpFixCore = fix = cleanUp != null ? cleanUp.createFix(context) : null;
                if (fix != null) break block3;
                return null;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logError(String.format("Failed to create text edit for clean up %s", cleanUp.getIdentifiers().iterator().next()));
                return null;
            }
        }
        CompilationUnitChange cleanUpChange = fix.createChange(monitor);
        TextEdit jdtEdit = cleanUpChange.getEdit();
        return jdtEdit;
    }

    private static CompilationUnit createASTWithOpts(ICompilationUnit cu, Map<String, String> opts, IProgressMonitor monitor) {
        ASTParser astParser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        astParser.setSource(cu);
        astParser.setResolveBindings(true);
        astParser.setStatementsRecovery(true);
        astParser.setBindingsRecovery(true);
        astParser.setCompilerOptions(opts);
        return (CompilationUnit)astParser.createAST(monitor);
    }
}

