/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

class EditableView
extends ComponentView {
    private boolean isVisible;

    EditableView(Element element) {
        super(element);
    }

    @Override
    public float getMinimumSpan(int n) {
        if (this.isVisible) {
            return super.getMinimumSpan(n);
        }
        return 0.0f;
    }

    @Override
    public float getPreferredSpan(int n) {
        if (this.isVisible) {
            return super.getPreferredSpan(n);
        }
        return 0.0f;
    }

    @Override
    public float getMaximumSpan(int n) {
        if (this.isVisible) {
            return super.getMaximumSpan(n);
        }
        return 0.0f;
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        Component component = this.getComponent();
        Container container = this.getContainer();
        if (container instanceof JTextComponent && this.isVisible != ((JTextComponent)container).isEditable()) {
            this.isVisible = ((JTextComponent)container).isEditable();
            this.preferenceChanged(null, true, true);
            container.repaint();
        }
        if (this.isVisible) {
            super.paint(graphics, shape);
        } else {
            this.setSize(0.0f, 0.0f);
        }
        if (component != null) {
            component.setFocusable(this.isVisible);
        }
    }

    @Override
    public void setParent(View view) {
        Container container;
        if (view != null && (container = view.getContainer()) != null) {
            this.isVisible = container instanceof JTextComponent ? ((JTextComponent)container).isEditable() : false;
        }
        super.setParent(view);
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }
}

