/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.math.BigInteger;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import sun.security.provider.certpath.CertPathConstraintsParameters;
import sun.security.provider.certpath.PKIX;
import sun.security.util.Debug;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.KeyUtil;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X509CertImpl;

public final class AlgorithmChecker
extends PKIXCertPathChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private final AlgorithmConstraints constraints;
    private final PublicKey trustedPubKey;
    private final Date date;
    private PublicKey prevPubKey;
    private final String variant;
    private TrustAnchor anchor;
    private static final Set<CryptoPrimitive> SIGNATURE_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    private static final Set<CryptoPrimitive> KU_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE, CryptoPrimitive.KEY_ENCAPSULATION, CryptoPrimitive.PUBLIC_KEY_ENCRYPTION, CryptoPrimitive.KEY_AGREEMENT));
    private static final DisabledAlgorithmConstraints certPathDefaultConstraints = DisabledAlgorithmConstraints.certPathConstraints();

    public AlgorithmChecker(TrustAnchor trustAnchor, String string) {
        this(trustAnchor, certPathDefaultConstraints, null, string);
    }

    public AlgorithmChecker(AlgorithmConstraints algorithmConstraints, String string) {
        this(null, algorithmConstraints, null, string);
    }

    public AlgorithmChecker(TrustAnchor trustAnchor, AlgorithmConstraints algorithmConstraints, Date date, String string) {
        if (trustAnchor != null) {
            this.trustedPubKey = trustAnchor.getTrustedCert() != null ? trustAnchor.getTrustedCert().getPublicKey() : trustAnchor.getCAPublicKey();
            this.anchor = trustAnchor;
        } else {
            this.trustedPubKey = null;
        }
        this.prevPubKey = this.trustedPubKey;
        this.constraints = algorithmConstraints == null ? certPathDefaultConstraints : algorithmConstraints;
        this.date = date;
        this.variant = string == null ? "generic" : string;
    }

    public AlgorithmChecker(TrustAnchor trustAnchor, Date date, String string) {
        this(trustAnchor, certPathDefaultConstraints, date, string);
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (!bl) {
            this.prevPubKey = this.trustedPubKey != null ? this.trustedPubKey : null;
        } else {
            throw new CertPathValidatorException("forward checking not supported");
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        AlgorithmId algorithmId;
        X509CertImpl x509CertImpl;
        if (!(certificate instanceof X509Certificate) || this.constraints == null) {
            return;
        }
        boolean[] blArray = ((X509Certificate)certificate).getKeyUsage();
        if (blArray != null && blArray.length < 9) {
            throw new CertPathValidatorException("incorrect KeyUsage extension", null, null, -1, PKIXReason.INVALID_KEY_USAGE);
        }
        try {
            x509CertImpl = X509CertImpl.toImpl((X509Certificate)certificate);
            algorithmId = (AlgorithmId)x509CertImpl.get("x509.algorithm");
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException(certificateException);
        }
        AlgorithmParameters algorithmParameters = algorithmId.getParameters();
        PublicKey publicKey = certificate.getPublicKey();
        String string = x509CertImpl.getSigAlgName();
        if (!this.constraints.permits(SIGNATURE_PRIMITIVE_SET, string, algorithmParameters)) {
            throw new CertPathValidatorException("Algorithm constraints check failed on signature algorithm: " + string, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }
        Set<CryptoPrimitive> set = KU_PRIMITIVE_SET;
        if (blArray != null) {
            set = EnumSet.noneOf(CryptoPrimitive.class);
            if (blArray[0] || blArray[1] || blArray[5] || blArray[6]) {
                set.add(CryptoPrimitive.SIGNATURE);
            }
            if (blArray[2]) {
                set.add(CryptoPrimitive.KEY_ENCAPSULATION);
            }
            if (blArray[3]) {
                set.add(CryptoPrimitive.PUBLIC_KEY_ENCRYPTION);
            }
            if (blArray[4]) {
                set.add(CryptoPrimitive.KEY_AGREEMENT);
            }
            if (set.isEmpty()) {
                throw new CertPathValidatorException("incorrect KeyUsage extension bits", null, null, -1, PKIXReason.INVALID_KEY_USAGE);
            }
        }
        CertPathConstraintsParameters certPathConstraintsParameters = new CertPathConstraintsParameters(x509CertImpl, this.variant, this.anchor, this.date);
        if (this.constraints instanceof DisabledAlgorithmConstraints) {
            ((DisabledAlgorithmConstraints)this.constraints).permits(string, algorithmParameters, certPathConstraintsParameters, true);
        } else {
            certPathDefaultConstraints.permits(string, algorithmParameters, certPathConstraintsParameters, true);
            if (!this.constraints.permits(set, publicKey)) {
                throw new CertPathValidatorException("Algorithm constraints check failed on key " + publicKey.getAlgorithm() + " with size of " + KeyUtil.getKeySize(publicKey) + "bits", null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
        if (this.prevPubKey == null) {
            this.prevPubKey = publicKey;
            return;
        }
        if (!this.constraints.permits(SIGNATURE_PRIMITIVE_SET, string, this.prevPubKey, algorithmParameters)) {
            throw new CertPathValidatorException("Algorithm constraints check failed on signature algorithm: " + string, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }
        if (PKIX.isDSAPublicKeyWithoutParams(publicKey)) {
            if (!(this.prevPubKey instanceof DSAPublicKey)) {
                throw new CertPathValidatorException("Input key is not of a appropriate type for inheriting parameters");
            }
            DSAParams dSAParams = ((DSAPublicKey)this.prevPubKey).getParams();
            if (dSAParams == null) {
                throw new CertPathValidatorException("Key parameters missing from public key.");
            }
            try {
                BigInteger bigInteger = ((DSAPublicKey)publicKey).getY();
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger, dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
                publicKey = keyFactory.generatePublic(dSAPublicKeySpec);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CertPathValidatorException("Unable to generate key with inherited parameters: " + generalSecurityException.getMessage(), generalSecurityException);
            }
        }
        this.prevPubKey = publicKey;
    }

    void trySetTrustAnchor(TrustAnchor trustAnchor) {
        if (this.prevPubKey == null) {
            if (trustAnchor == null) {
                throw new IllegalArgumentException("The trust anchor cannot be null");
            }
            this.prevPubKey = trustAnchor.getTrustedCert() != null ? trustAnchor.getTrustedCert().getPublicKey() : trustAnchor.getCAPublicKey();
            this.anchor = trustAnchor;
        }
    }

    static void check(PublicKey publicKey, AlgorithmId algorithmId, String string, TrustAnchor trustAnchor) throws CertPathValidatorException {
        certPathDefaultConstraints.permits(algorithmId.getName(), algorithmId.getParameters(), new CertPathConstraintsParameters(publicKey, string, trustAnchor), true);
    }
}

