/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.AccessController;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IgnoreAllErrorHandler
implements ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreAllErrorHandler.class);
    private static final boolean warnOnExceptions = IgnoreAllErrorHandler.getProperty("com.sun.org.apache.xml.internal.security.test.warn.on.exceptions");
    private static final boolean throwExceptions = IgnoreAllErrorHandler.getProperty("com.sun.org.apache.xml.internal.security.test.throw.exceptions");

    private static boolean getProperty(String string) {
        return AccessController.doPrivileged(() -> Boolean.getBoolean(string));
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (warnOnExceptions) {
            LOG.warn("", sAXParseException);
        }
        if (throwExceptions) {
            throw sAXParseException;
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        if (warnOnExceptions) {
            LOG.error("", sAXParseException);
        }
        if (throwExceptions) {
            throw sAXParseException;
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (warnOnExceptions) {
            LOG.warn("", sAXParseException);
        }
        if (throwExceptions) {
            throw sAXParseException;
        }
    }
}

