/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.spi;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.scout.sdk.core.typescript.model.api.IConstantValue;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataTypeOwner;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.internal.DataTypeImplementor;
import org.eclipse.scout.sdk.core.typescript.model.spi.AbstractNodeElementSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.DataTypeSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class ConstantValueDataTypeSpi
extends AbstractNodeElementSpi<IDataType>
implements DataTypeSpi {
    private final IConstantValue m_constantValue;
    private final FinalValue<String> m_name = new FinalValue();

    protected ConstantValueDataTypeSpi(NodeModuleSpi module, IConstantValue constantValue) {
        super(module);
        this.m_constantValue = constantValue;
    }

    @Override
    public INodeElement.ExportType exportType() {
        return INodeElement.ExportType.NONE;
    }

    @Override
    protected Path resolveContainingFile() {
        return this.constantValue().flatMap(IConstantValue::containingFile).orElse(null);
    }

    @Override
    public Collection<DataTypeSpi> childTypes() {
        return Collections.emptyList();
    }

    @Override
    protected IDataType createApi() {
        return new DataTypeImplementor<ConstantValueDataTypeSpi>(this);
    }

    @Override
    public Optional<IConstantValue> constantValue() {
        return Optional.of(this.m_constantValue);
    }

    @Override
    public String name() {
        return (String)this.m_name.computeIfAbsentAndGet(() -> this.constantValue().flatMap(IConstantValue::value).map(v -> {
            if (v instanceof INodeElement) {
                INodeElement nodeElement = (INodeElement)v;
                return nodeElement.name();
            }
            return v.toString();
        }).orElse(null));
    }

    @Override
    public boolean isPrimitive() {
        return this.constantValue().flatMap(IDataTypeOwner::dataType).map(IDataType::isPrimitive).orElse(false);
    }

    @Override
    public Optional<SourceRange> source() {
        return Optional.empty();
    }
}

