/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.xmlrpc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.TimeZone;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.DigestScheme;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.apache.xmlrpc.serializer.CharSetXmlWriterFactory;
import org.apache.xmlrpc.serializer.XmlWriterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.commons.xmlrpc.HttpClientTransportFactory;
import org.eclipse.mylyn.internal.commons.xmlrpc.HttpMethodInterceptor;
import org.eclipse.mylyn.internal.commons.xmlrpc.Multicall;
import org.eclipse.mylyn.internal.commons.xmlrpc.MulticallResult;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcIllegalContentTypeException;
import org.eclipse.mylyn.internal.commons.xmlrpc.XmlRpcOperation;
import org.eclipse.osgi.util.NLS;

public class CommonXmlRpcClient {
    static final boolean DEBUG_AUTH = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.mylyn.commons.xmlrpc/debug/authentication"));
    static final boolean DEBUG_XMLRPC = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.mylyn.commons.xmlrpc/debug/xmlrpc"));
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String DEFAULT_TIME_ZONE = TimeZone.getDefault().getID();
    private static final String DEFAULT_USER_AGENT = "Apache XML-RPC/3.0";
    private static final String DEFAULT_CONTENT_TYPE = "text/xml";
    private final AuthScope authScope;
    private XmlRpcClientConfigImpl config;
    volatile DigestScheme digestScheme;
    private HttpClientTransportFactory factory;
    final HttpClient httpClient;
    private final AbstractWebLocation location;
    private XmlRpcClient xmlrpc;
    private volatile boolean contentTypeCheckingEnabled;

    private static HttpClient createHttpClient(String userAgent) {
        HttpClient httpClient = new HttpClient();
        httpClient.setHttpConnectionManager(WebUtil.getConnectionManager());
        httpClient.getParams().setCookiePolicy("rfc2109");
        WebUtil.configureHttpClient((HttpClient)httpClient, (String)userAgent);
        return httpClient;
    }

    public CommonXmlRpcClient(AbstractWebLocation location) {
        this(location, CommonXmlRpcClient.createHttpClient(DEFAULT_USER_AGENT));
    }

    public CommonXmlRpcClient(AbstractWebLocation location, HttpClient client) {
        this.location = location;
        this.httpClient = CommonXmlRpcClient.createHttpClient(DEFAULT_USER_AGENT);
        this.authScope = new AuthScope(WebUtil.getHost((String)location.getUrl()), WebUtil.getPort((String)location.getUrl()), null, AuthScope.ANY_SCHEME);
    }

    public <T> T call(final IProgressMonitor monitor, final String method, final Object ... parameters) throws XmlRpcException {
        return new XmlRpcOperation<T>(this){

            @Override
            public T execute() throws XmlRpcException {
                return this.call(monitor, method, parameters);
            }
        }.execute();
    }

    public MulticallResult call(final IProgressMonitor monitor, final Multicall call) throws XmlRpcException {
        return new XmlRpcOperation<MulticallResult>(this){

            @Override
            public MulticallResult execute() throws XmlRpcException {
                return this.call(monitor, call);
            }
        }.execute();
    }

    protected void createXmlRpcClient() {
        this.config = new XmlRpcClientConfigImpl();
        this.config.setEncoding(DEFAULT_CHARSET);
        this.config.setTimeZone(TimeZone.getTimeZone(DEFAULT_TIME_ZONE));
        this.config.setContentLengthOptional(false);
        this.config.setConnectionTimeout(WebUtil.getConnectionTimeout());
        this.config.setReplyTimeout(WebUtil.getSocketTimeout());
        this.xmlrpc = new XmlRpcClient();
        this.xmlrpc.setConfig((XmlRpcClientConfig)this.config);
        this.xmlrpc.setXmlWriterFactory((XmlWriterFactory)new CharSetXmlWriterFactory());
        this.factory = new HttpClientTransportFactory(this.xmlrpc, this.httpClient);
        this.factory.setLocation(this.location);
        this.factory.setInterceptor(new HttpMethodInterceptor(){

            @Override
            public void processRequest(HttpMethod method) {
                DigestScheme scheme = CommonXmlRpcClient.this.digestScheme;
                if (scheme != null) {
                    Credentials creds;
                    if (DEBUG_AUTH) {
                        System.err.println(CommonXmlRpcClient.this.location.getUrl() + ": Digest scheme is present");
                    }
                    if ((creds = CommonXmlRpcClient.this.httpClient.getState().getCredentials(CommonXmlRpcClient.this.authScope)) != null) {
                        if (DEBUG_AUTH) {
                            System.err.println(CommonXmlRpcClient.this.location.getUrl() + ": Setting digest scheme for request");
                        }
                        method.getHostAuthState().setAuthScheme((AuthScheme)CommonXmlRpcClient.this.digestScheme);
                        method.getHostAuthState().setAuthRequested(true);
                    }
                }
            }

            @Override
            public void processResponse(HttpMethod method) throws XmlRpcException {
                Header contentTypeHeader;
                if (CommonXmlRpcClient.this.isContentTypeCheckingEnabled() && ((contentTypeHeader = method.getResponseHeader("Content-Type")) == null || !CommonXmlRpcClient.DEFAULT_CONTENT_TYPE.equals(contentTypeHeader.getValue()))) {
                    throw new XmlRpcIllegalContentTypeException(NLS.bind((String)"The server returned an unexpected content type: ''{0}''", (Object)contentTypeHeader.getValue()), contentTypeHeader.getValue());
                }
                AuthScheme authScheme = method.getHostAuthState().getAuthScheme();
                if (authScheme instanceof DigestScheme) {
                    CommonXmlRpcClient.this.digestScheme = (DigestScheme)authScheme;
                    if (DEBUG_AUTH) {
                        System.err.println(CommonXmlRpcClient.this.location.getUrl() + ": Received digest scheme");
                    }
                }
            }
        });
        this.xmlrpc.setTransportFactory((XmlRpcTransportFactory)this.factory);
        try {
            this.config.setServerURL(new URL(this.location.getUrl()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized XmlRpcClient getClient() {
        if (this.xmlrpc == null) {
            this.createXmlRpcClient();
        }
        return this.xmlrpc;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public AbstractWebLocation getLocation() {
        return this.location;
    }

    AuthenticationCredentials updateCredentials() {
        AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
        if (credentials != null) {
            Credentials httpCredentials = WebUtil.getHttpClientCredentials((AuthenticationCredentials)credentials, (String)WebUtil.getHost((String)this.location.getUrl()));
            this.httpClient.getState().setCredentials(this.authScope, httpCredentials);
            this.httpClient.getState().setCredentials(this.authScope, httpCredentials);
        } else {
            this.httpClient.getState().clearCredentials();
        }
        return credentials;
    }

    public boolean isContentTypeCheckingEnabled() {
        return this.contentTypeCheckingEnabled;
    }

    public void setContentTypeCheckingEnabled(boolean contentTypeCheckingEnabled) {
        this.contentTypeCheckingEnabled = contentTypeCheckingEnabled;
    }
}

