/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.command.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.sirius.tools.api.command.ui.RefreshFilter;
import org.eclipse.sirius.tools.api.command.ui.RefreshFilterManager;
import org.eclipse.sirius.viewpoint.DRepresentation;

public final class RefreshFilterManagerImpl
implements RefreshFilterManager {
    private final Collection<RefreshFilter> filters = new ArrayList<RefreshFilter>();

    private RefreshFilterManagerImpl() {
    }

    public static RefreshFilterManager init() {
        RefreshFilterManagerImpl manager = new RefreshFilterManagerImpl();
        return manager;
    }

    @Override
    public void addRefreshFilter(RefreshFilter filter) {
        this.filters.add(filter);
    }

    @Override
    public void clearRefreshFilter() {
        this.filters.clear();
    }

    @Override
    public void removeRefreshFilter(RefreshFilter filter) {
        this.filters.remove(filter);
    }

    @Override
    public boolean shouldRefresh(DRepresentation representation) {
        for (RefreshFilter filter : this.filters) {
            if (filter.shouldRefresh(representation)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<DRepresentation> getOpenedRepresantationsToRefresh() {
        LinkedHashSet<DRepresentation> representations = new LinkedHashSet<DRepresentation>();
        for (RefreshFilter filter : this.filters) {
            representations.addAll(filter.getOpenedRepresantationsToRefresh());
        }
        return representations;
    }
}

