/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.scout.sdk.core.java.ecj.ClasspathBuilder;
import org.eclipse.scout.sdk.core.java.ecj.ClasspathEntry;
import org.eclipse.scout.sdk.core.java.ecj.CompilationUnitOverrideSupport;
import org.eclipse.scout.sdk.core.java.ecj.JreInfo;

public class FileSystemWithOverride
extends FileSystem {
    private final JreInfo m_jreInfo;
    private final CompilationUnitOverrideSupport m_overrideSupport;
    private final Set<ClasspathEntry> m_cpEntries;

    protected FileSystemWithOverride(ClasspathBuilder cp) {
        super(cp.fullClasspath().toArray(new FileSystem.Classpath[0]), null, false);
        this.m_jreInfo = cp.jreInfo();
        this.m_cpEntries = cp.userClasspathEntries();
        this.m_overrideSupport = new CompilationUnitOverrideSupport();
    }

    private NameEnvironmentAnswer searchInOverrideSupport(char[] typeName, char[][] packageName) {
        char[] fqnWithSlash = CharOperation.concatWith((char[][])packageName, (char[])typeName, (char)'/');
        ICompilationUnit overrideCu = this.overrideSupport().get(fqnWithSlash);
        if (overrideCu != null) {
            return new NameEnvironmentAnswer(overrideCu, null);
        }
        return null;
    }

    private NameEnvironmentAnswer searchInOverrideSupport(char[][] compoundName) {
        char[] fqnWithSlash = CharOperation.concatWith((char[][])compoundName, (char)'/');
        ICompilationUnit overrideCu = this.overrideSupport().get(fqnWithSlash);
        if (overrideCu != null) {
            return new NameEnvironmentAnswer(overrideCu, null);
        }
        return null;
    }

    public char[][] getModulesDeclaringPackage(char[][] packageName, char[] moduleName) {
        char[][] classpathModules = super.getModulesDeclaringPackage(packageName, moduleName);
        if (FileSystemWithOverride.hasModule(moduleName)) {
            return classpathModules;
        }
        if (FileSystemWithOverride.containsUnnamedModuleName(classpathModules)) {
            return classpathModules;
        }
        char[] fqnWithSlash = CharOperation.concatWith((char[][])packageName, (char)'/');
        if (!this.overrideSupport().containsPackage(fqnWithSlash)) {
            return classpathModules;
        }
        return FileSystemWithOverride.withUnnamedModule(classpathModules);
    }

    protected static char[][] withUnnamedModule(char[][] existing) {
        if (existing == null) {
            return new char[][]{ModuleBinding.UNNAMED};
        }
        char[][] result = new char[existing.length + 1][];
        System.arraycopy(existing, 0, result, 0, existing.length);
        result[existing.length] = ModuleBinding.UNNAMED;
        return result;
    }

    protected static boolean containsUnnamedModuleName(char[][] moduleNames) {
        if (moduleNames == null || moduleNames.length < 1) {
            return false;
        }
        for (char[] module : moduleNames) {
            if (!CharOperation.equals((char[])module, (char[])ModuleBinding.UNNAMED)) continue;
            return true;
        }
        return false;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName, char[] moduleName) {
        NameEnvironmentAnswer answer;
        if (!FileSystemWithOverride.hasModule(moduleName) && (answer = this.searchInOverrideSupport(compoundName)) != null) {
            return answer;
        }
        return super.findType(compoundName, moduleName);
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
        NameEnvironmentAnswer answer;
        if (!FileSystemWithOverride.hasModule(moduleName) && (answer = this.searchInOverrideSupport(typeName, packageName)) != null) {
            return answer;
        }
        return super.findType(typeName, packageName, moduleName);
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        char[] fqnWithSlash = CharOperation.concatWith((char[][])compoundName, (char[])packageName, (char)'/');
        return this.overrideSupport().containsPackage(fqnWithSlash) || super.isPackage(compoundName, packageName);
    }

    public boolean hasCompilationUnit(char[][] qualifiedPackageName, char[] moduleName, boolean checkCUs) {
        if (!FileSystemWithOverride.hasModule(moduleName)) {
            for (ICompilationUnit icu : this.overrideSupport().getCompilationUnits()) {
                if (!CharOperation.equals((char[][])icu.getPackageName(), (char[][])qualifiedPackageName)) continue;
                return true;
            }
        }
        return super.hasCompilationUnit(qualifiedPackageName, moduleName, checkCUs);
    }

    protected static boolean hasModule(char[] moduleName) {
        return moduleName != null && moduleName.length > 0;
    }

    public CompilationUnitOverrideSupport overrideSupport() {
        return this.m_overrideSupport;
    }

    public Set<? extends ClasspathEntry> classpath() {
        return this.m_cpEntries;
    }

    public JreInfo jreInfo() {
        return this.m_jreInfo;
    }

    public void cleanup() {
        this.m_overrideSupport.clear();
        this.m_cpEntries.clear();
        super.cleanup();
    }
}

