/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.builder;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.util.Ensure;

public class JavaBuilderContextFunction<R>
implements Function<IJavaBuilderContext, R> {
    private final boolean m_requireContext;
    private final Function<IJavaBuilderContext, R> m_function;

    protected JavaBuilderContextFunction(R constValue) {
        this(c -> constValue, false);
    }

    protected JavaBuilderContextFunction(Function<IJavaBuilderContext, R> func) {
        this(func, true);
    }

    protected JavaBuilderContextFunction(Function<IJavaBuilderContext, R> func, boolean requireContext) {
        this.m_function = (Function)Ensure.notNull(func);
        this.m_requireContext = requireContext;
    }

    public static <R> JavaBuilderContextFunction<R> orNull(R constValue) {
        if (constValue == null) {
            return null;
        }
        return JavaBuilderContextFunction.create(constValue);
    }

    public static <R> JavaBuilderContextFunction<R> orNull(Function<IJavaBuilderContext, R> function) {
        if (function == null) {
            return null;
        }
        return JavaBuilderContextFunction.create(function);
    }

    public static <R> JavaBuilderContextFunction<R> create(R constValue) {
        return new JavaBuilderContextFunction<Object>(Ensure.notNull(constValue));
    }

    public static <R> JavaBuilderContextFunction<R> create(Function<IJavaBuilderContext, R> function) {
        if (function instanceof JavaBuilderContextFunction) {
            return (JavaBuilderContextFunction)function;
        }
        return new JavaBuilderContextFunction<R>(function);
    }

    @Override
    public R apply(IJavaBuilderContext context) {
        return this.m_function.apply(context);
    }

    public Optional<R> apply() {
        if (this.isContextRequired()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.apply(null));
    }

    public boolean isContextRequired() {
        return this.m_requireContext;
    }

    public Function<IJavaBuilderContext, R> contextFunction() {
        return this.m_function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaBuilderContextFunction that = (JavaBuilderContextFunction)o;
        return this.m_function.equals(that.m_function);
    }

    public int hashCode() {
        return this.m_function.hashCode();
    }
}

