/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.builder;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.PropertySupport;
import org.eclipse.scout.sdk.core.util.Strings;

public class BuilderContext
implements IBuilderContext {
    private final String m_nl;
    private final FinalValue<PropertySupport> m_properties;

    public BuilderContext() {
        this(null);
    }

    public BuilderContext(String nl) {
        this(nl, null);
    }

    public BuilderContext(String nl, PropertySupport properties) {
        this.m_nl = Strings.notEmpty(nl).orElse("\n");
        this.m_properties = new FinalValue();
        Optional.ofNullable(properties).ifPresent(this.m_properties::set);
    }

    @Override
    public String lineDelimiter() {
        return this.m_nl;
    }

    @Override
    public PropertySupport properties() {
        return this.m_properties.computeIfAbsentAndGet(PropertySupport::new);
    }

    public int hashCode() {
        int prime = 31;
        int h = prime + this.m_nl.hashCode();
        return prime * h + this.m_properties.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BuilderContext other = (BuilderContext)obj;
        return Objects.equals(this.m_nl, other.m_nl) && Objects.equals(this.m_properties, other.m_properties);
    }
}

