/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class WorkingSetRootModeActionGroup
extends ActionGroup {
    private IExtensionStateModel stateModel;
    private final StructuredViewer structuredViewer;
    private boolean hasContributedToViewMenu = false;
    private IAction workingSetsAction = null;
    private IAction projectsAction = null;
    private IAction[] actions;
    private int currentRadioSelection;
    private MenuItem[] items;

    public WorkingSetRootModeActionGroup(StructuredViewer aStructuredViewer, IExtensionStateModel aStateModel) {
        this.structuredViewer = aStructuredViewer;
        this.stateModel = aStateModel;
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.hasContributedToViewMenu) {
            return;
        }
        MenuManager topLevelSubMenu = new MenuManager(WorkbenchNavigatorMessages.WorkingSetRootModeActionGroup_Top_Level_Element_);
        this.addActions((IMenuManager)topLevelSubMenu);
        actionBars.getMenuManager().insertBefore("additions", (IContributionItem)topLevelSubMenu);
        this.hasContributedToViewMenu = true;
    }

    protected void addActions(IMenuManager viewMenu) {
        if (this.actions == null) {
            this.actions = this.createActions();
        }
        viewMenu.add((IContributionItem)new Separator());
        this.items = new MenuItem[this.actions.length];
        int i = 0;
        while (i < this.actions.length) {
            final int j = i;
            final IAction action = this.actions[i];
            ContributionItem item = new ContributionItem(){

                public void fill(Menu menu, int index) {
                    MenuItem mi;
                    int style = 32;
                    if ((action.getStyle() & 8) != 0) {
                        style = 16;
                    }
                    WorkingSetRootModeActionGroup.this.items[j] = mi = new MenuItem(menu, style, index);
                    mi.setText(action.getText());
                    mi.setSelection(WorkingSetRootModeActionGroup.this.currentRadioSelection == j);
                    if (style == 16) {
                        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if ((this).WorkingSetRootModeActionGroup.this.currentRadioSelection == j) {
                                    (this).WorkingSetRootModeActionGroup.this.items[(this).WorkingSetRootModeActionGroup.this.currentRadioSelection].setSelection(true);
                                    return;
                                }
                                (this).WorkingSetRootModeActionGroup.this.actions[j].run();
                                (this).WorkingSetRootModeActionGroup.this.items[(this).WorkingSetRootModeActionGroup.this.currentRadioSelection].setSelection(false);
                                (this).WorkingSetRootModeActionGroup.this.currentRadioSelection = j;
                                (this).WorkingSetRootModeActionGroup.this.items[(this).WorkingSetRootModeActionGroup.this.currentRadioSelection].setSelection(true);
                            }
                        });
                    } else {
                        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                action.run();
                            }
                        });
                    }
                    mi.setEnabled(action.isEnabled());
                }

                public boolean isDynamic() {
                    return false;
                }
            };
            viewMenu.add((IContributionItem)item);
            ++i;
        }
    }

    private IAction[] createActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.projectsAction = new TopLevelContentAction(false);
        this.projectsAction.setText(WorkbenchNavigatorMessages.WorkingSetRootModeActionGroup_Project_);
        this.projectsAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_OBJ_PROJECT"));
        this.workingSetsAction = new TopLevelContentAction(true);
        this.workingSetsAction.setText(WorkbenchNavigatorMessages.WorkingSetRootModeActionGroup_Working_Set_);
        this.workingSetsAction.setImageDescriptor(WorkbenchNavigatorPlugin.getDefault().getImageRegistry().getDescriptor("full/obj16/workingsets.svg"));
        return new IAction[]{this.projectsAction, this.workingSetsAction};
    }

    public void setShowTopLevelWorkingSets(boolean showTopLevelWorkingSets) {
        if (this.actions == null) {
            this.actions = this.createActions();
        }
        this.currentRadioSelection = showTopLevelWorkingSets ? 1 : 0;
        this.workingSetsAction.setChecked(showTopLevelWorkingSets);
        this.projectsAction.setChecked(!showTopLevelWorkingSets);
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null && this.actions[i] != null) {
                    this.items[i].setSelection(this.actions[i].isChecked());
                }
                ++i;
            }
        }
        if (this.stateModel != null) {
            this.stateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", showTopLevelWorkingSets);
        }
    }

    public void setStateModel(IExtensionStateModel sStateModel) {
        this.stateModel = sStateModel;
    }

    private class TopLevelContentAction
    extends Action {
        private final boolean groupWorkingSets;

        public TopLevelContentAction(boolean toGroupWorkingSets) {
            super("", 8);
            this.groupWorkingSets = toGroupWorkingSets;
        }

        public void run() {
            if (WorkingSetRootModeActionGroup.this.stateModel.getBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets") != this.groupWorkingSets) {
                WorkingSetRootModeActionGroup.this.stateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", this.groupWorkingSets);
                WorkingSetRootModeActionGroup.this.structuredViewer.getControl().setRedraw(false);
                try {
                    WorkingSetRootModeActionGroup.this.structuredViewer.refresh();
                }
                finally {
                    WorkingSetRootModeActionGroup.this.structuredViewer.getControl().setRedraw(true);
                }
            }
        }
    }
}

