/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class FocusTracker {
    private Control lastFocusControl;
    private final FocusListener listener = new FocusAdapter(){

        public void focusGained(FocusEvent e) {
            FocusTracker.this.lastFocusControl = (Control)e.widget;
        }
    };

    public void track(Composite composite) {
        Control[] children;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Text || control instanceof Button || control instanceof Combo || control instanceof CCombo || control instanceof Tree || control instanceof Table || control instanceof Spinner || control instanceof Link || control instanceof List || control instanceof TabFolder || control instanceof CTabFolder || control instanceof Hyperlink || control instanceof FilteredTree || control instanceof StyledText) {
                control.addFocusListener(this.listener);
            }
            if (control instanceof Composite) {
                this.track((Composite)control);
            }
            ++n2;
        }
    }

    public void reset() {
        this.lastFocusControl = null;
    }

    public boolean setFocus() {
        if (this.lastFocusControl != null && !this.lastFocusControl.isDisposed()) {
            return this.lastFocusControl.setFocus();
        }
        return false;
    }
}

