/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;

public class SimpleNamespaceContext
implements NamespaceContext,
Serializable {
    private static final long serialVersionUID = -808928409643497762L;
    private Map<String, String> namespaces;

    public SimpleNamespaceContext() {
        this.namespaces = new HashMap<String, String>();
    }

    public SimpleNamespaceContext(Map namespaces) {
        for (Map.Entry entry : namespaces.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
            throw new ClassCastException("Non-string namespace binding");
        }
        this.namespaces = new HashMap<String, String>(namespaces);
    }

    public void addElementNamespaces(Navigator nav, Object element) throws UnsupportedAxisException {
        Iterator namespaceAxis = nav.getNamespaceAxisIterator(element);
        while (namespaceAxis.hasNext()) {
            Object namespace = namespaceAxis.next();
            String prefix = nav.getNamespacePrefix(namespace);
            String uri = nav.getNamespaceStringValue(namespace);
            if (this.translateNamespacePrefixToUri(prefix) != null) continue;
            this.addNamespace(prefix, uri);
        }
    }

    public void addNamespace(String prefix, String URI) {
        this.namespaces.put(prefix, URI);
    }

    public String translateNamespacePrefixToUri(String prefix) {
        if (this.namespaces.containsKey(prefix)) {
            return this.namespaces.get(prefix);
        }
        return null;
    }
}

