/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;

class WorkspaceFileHyperlink
implements IHyperlink {
    private IFile fFile;
    private IRegion fHighlightRange;
    private IRegion fRegion;

    public WorkspaceFileHyperlink(IRegion region, IFile file) {
        this.fRegion = region;
        this.fFile = file;
    }

    public WorkspaceFileHyperlink(IRegion region, IFile file, IRegion range) {
        this.fRegion = region;
        this.fFile = file;
        this.fHighlightRange = range;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getHyperlinkText() {
        String path = this.fFile.getFullPath().toString();
        if (path.length() > 60) {
            path = String.valueOf(path.substring(0, 25)) + "..." + path.substring(path.length() - 25, path.length());
        }
        return NLS.bind((String)HTMLUIMessages.Open, (Object)path);
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        if (this.fFile != null && this.fFile.exists()) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)this.fFile, (boolean)true);
                if (this.fHighlightRange != null && editor != null) {
                    ITextEditor textEditor = null;
                    textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
                    if (textEditor != null) {
                        textEditor.selectAndReveal(this.fHighlightRange.getOffset(), this.fHighlightRange.getLength());
                    }
                }
            }
            catch (PartInitException pie) {
                Logger.log(202, pie.getMessage(), pie);
            }
        }
    }
}

