/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.dialogs;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.pagedesigner.ui.dialogs.DialogsMessages;
import org.eclipse.jst.pagedesigner.ui.dialogs.IStyleConstants;
import org.eclipse.jst.pagedesigner.ui.dialogs.StyleCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class ExtensionsPreferencePage
extends PreferencePage {
    private CSSPropertyContext _style;
    private StyleCombo _beforeCombo;
    private StyleCombo _afterCombo;
    private StyleCombo _cursorCombo;

    public ExtensionsPreferencePage(IDOMElement element, CSSPropertyContext style) {
        this._style = style;
        this.setTitle(DialogsMessages.getString("ExtensionsPreferencePage.Title"));
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData data = new GridData(1808);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)data);
        Group pageGroup = new Group(top, 0);
        pageGroup.setText(DialogsMessages.getString("ExtensionsPreferencePage.PageBreak"));
        data = new GridData(768);
        pageGroup.setLayoutData((Object)data);
        layout = new GridLayout(2, false);
        pageGroup.setLayout((Layout)layout);
        Label beforeLabel = new Label((Composite)pageGroup, 0);
        beforeLabel.setText(DialogsMessages.getString("ExtensionsPreferencePage.Before"));
        data = new GridData(128);
        beforeLabel.setLayoutData((Object)data);
        this._beforeCombo = new StyleCombo((Composite)pageGroup, 0);
        this._beforeCombo.setItems(IStyleConstants.PAGE_BREAK);
        data = new GridData(768);
        this._beforeCombo.setLayoutData(data);
        this._beforeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String page = ExtensionsPreferencePage.this._beforeCombo.getText();
                ExtensionsPreferencePage.this._style.setPageBreakBefore(page);
            }
        });
        Label afterLabel = new Label((Composite)pageGroup, 0);
        afterLabel.setText(DialogsMessages.getString("ExtensionsPreferencePage.After"));
        data = new GridData(128);
        afterLabel.setLayoutData((Object)data);
        this._afterCombo = new StyleCombo((Composite)pageGroup, 0);
        this._afterCombo.setItems(IStyleConstants.PAGE_BREAK);
        data = new GridData(768);
        this._afterCombo.setLayoutData(data);
        this._afterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String page = ExtensionsPreferencePage.this._afterCombo.getText();
                ExtensionsPreferencePage.this._style.setPageBreakAfter(page);
            }
        });
        Group visualGroup = new Group(top, 0);
        visualGroup.setText(DialogsMessages.getString("ExtensionsPreferencePage.VisualEffect"));
        data = new GridData(768);
        visualGroup.setLayoutData((Object)data);
        layout = new GridLayout(2, false);
        visualGroup.setLayout((Layout)layout);
        Label cursorLabel = new Label((Composite)visualGroup, 0);
        cursorLabel.setText(DialogsMessages.getString("ExtensionsPreferencePage.Cursor"));
        data = new GridData(128);
        cursorLabel.setLayoutData((Object)data);
        this._cursorCombo = new StyleCombo((Composite)visualGroup, 0);
        this._cursorCombo.setItems(IStyleConstants.CURSOR);
        data = new GridData(768);
        this._cursorCombo.setLayoutData(data);
        this._cursorCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String cursor = ExtensionsPreferencePage.this._cursorCombo.getText();
                ExtensionsPreferencePage.this._style.setCursor(cursor);
            }
        });
        this.initializeControls();
        return top;
    }

    private void initializeControls() {
        String cursor;
        int index;
        String page = this._style.getPageBreakBefore();
        if (!this.isEmptyString(page)) {
            index = this._beforeCombo.indexOf(page);
            if (index != -1) {
                this._beforeCombo.select(index);
            } else {
                this._beforeCombo.setText(page);
            }
        }
        if (!this.isEmptyString(page = this._style.getPageBreakAfter())) {
            index = this._afterCombo.indexOf(page);
            if (index != -1) {
                this._afterCombo.select(index);
            } else {
                this._afterCombo.setText(page);
            }
        }
        if (!this.isEmptyString(cursor = this._style.getCursor())) {
            int index2 = this._cursorCombo.indexOf(cursor);
            if (index2 != -1) {
                this._cursorCombo.select(index2);
            } else {
                this._cursorCombo.setText(cursor);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getApplyButton().setVisible(false);
        this.getDefaultsButton().setVisible(false);
    }

    private boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }
}

