/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.corext.codemanipulation;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.InvalidInputException;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.DLTKUIStatus;
import org.eclipse.dltk.javascript.internal.corext.codemanipulation.JSCodeGeneration;
import org.eclipse.dltk.javascript.internal.corext.codemanipulation.Signature;
import org.eclipse.dltk.javascript.scriptdoc.PublicScanner;
import org.eclipse.dltk.javascript.scriptdoc.ScriptdocContentAccess;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class AddJavaDocStubOperation
implements IWorkspaceRunnable {
    private IMember[] fMembers;

    public AddJavaDocStubOperation(IMember[] members) {
        Assert.isLegal((members.length > 0 ? 1 : 0) != 0);
        this.fMembers = members;
    }

    private String createTypeComment(IType type, String lineDelimiter) throws CoreException {
        String[] typeParameterNames = CharOperation.NO_STRINGS;
        return JSCodeGeneration.getTypeComment(type.getSourceModule(), type.getTypeQualifiedName("."), typeParameterNames, lineDelimiter);
    }

    private String createMethodComment(IMethod meth, String lineDelimiter) throws CoreException {
        IMethod overridden = null;
        meth.isConstructor();
        return JSCodeGeneration.getMethodComment(meth, overridden, lineDelimiter);
    }

    private String createFieldComment(IField field, String lineDelimiter) throws ModelException, CoreException {
        String existingComment = null;
        try {
            ISourceRange range = ScriptdocContentAccess.getJavadocRange((IMember)field);
            if (range != null) {
                ISourceModule compilationUnit = field.getSourceModule();
                existingComment = compilationUnit.getBuffer().getText(range.getOffset(), range.getLength());
            }
        }
        catch (Exception exception) {}
        String typeName = Signature.toString(field.getType());
        if (existingComment != null && (typeName == null || existingComment.indexOf("@type " + typeName) != -1)) {
            return existingComment;
        }
        String fieldName = field.getElementName();
        return JSCodeGeneration.getFieldComment(field.getSourceModule(), typeName, fieldName, lineDelimiter);
    }

    public ISchedulingRule getScheduleRule() {
        return this.fMembers[0].getResource();
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("Create Javadoc stub...", this.fMembers.length + 2);
            this.addJavadocComments(monitor);
        }
        finally {
            monitor.done();
        }
    }

    private void addJavadocComments(IProgressMonitor monitor) throws CoreException {
        ISourceModule cu = this.fMembers[0].getSourceModule();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = cu.getPath();
        manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        try {
            try {
                IDocument document = manager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                MultiTextEdit edit = new MultiTextEdit();
                int i = 0;
                while (i < this.fMembers.length) {
                    block18: {
                        block19: {
                            String indentedComment;
                            int memberStartOffset;
                            block17: {
                                IMember curr = this.fMembers[i];
                                memberStartOffset = this.getMemberStartOffset(curr, document);
                                String comment = null;
                                switch (curr.getElementType()) {
                                    case 7: {
                                        comment = this.createTypeComment((IType)curr, lineDelim);
                                        break;
                                    }
                                    case 8: {
                                        comment = this.createFieldComment((IField)curr, lineDelim);
                                        break;
                                    }
                                    case 9: {
                                        comment = this.createMethodComment((IMethod)curr, lineDelim);
                                    }
                                }
                                if (comment == null) {
                                    StringBuffer buf = new StringBuffer();
                                    buf.append("/**").append(lineDelim);
                                    buf.append(" *").append(lineDelim);
                                    buf.append(" */").append(lineDelim);
                                    comment = buf.toString();
                                } else if (!comment.endsWith(lineDelim)) {
                                    comment = String.valueOf(comment) + lineDelim;
                                }
                                IScriptProject project = cu.getScriptProject();
                                IRegion region = document.getLineInformationOfOffset(memberStartOffset);
                                String line = document.get(region.getOffset(), region.getLength());
                                String indentString = JSCodeGeneration.getIndentString(line, project);
                                indentedComment = JSCodeGeneration.changeIndent(comment, 0, project, indentString, lineDelim);
                                ISourceRange range = ScriptdocContentAccess.getJavadocRange(curr);
                                if (range == null) break block17;
                                if (curr.getElementType() == 7) break block18;
                                int begin = range.getOffset();
                                int end = begin + range.getLength();
                                while (end < document.getLength() && Character.isWhitespace(document.getChar(end))) {
                                    ++end;
                                }
                                if (!indentedComment.equals(document.get(begin, end - begin))) {
                                    edit.addChild((TextEdit)new ReplaceEdit(begin, end - begin, indentedComment));
                                }
                                break block19;
                            }
                            edit.addChild((TextEdit)new InsertEdit(memberStartOffset, indentedComment));
                        }
                        monitor.worked(1);
                    }
                    ++i;
                }
                edit.apply(document);
            }
            catch (BadLocationException e) {
                throw new CoreException(DLTKUIStatus.createError((int)4, (Throwable)e));
            }
        }
        finally {
            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    private int getMemberStartOffset(IMember curr, IDocument document) throws ModelException {
        int offset;
        String docStr = document.get();
        String substring = docStr.substring(0, offset = curr.getSourceRange().getOffset());
        if (substring.endsWith("var ")) {
            offset -= 4;
        } else if (substring.endsWith("this.")) {
            offset -= 5;
        }
        PublicScanner scanner = new PublicScanner();
        scanner.setSource(docStr.toCharArray());
        try {
            scanner.resetTo(offset, scanner.getSource().length - 1);
            scanner.getNextToken();
            return scanner.getCurrentTokenStartPosition();
        }
        catch (InvalidInputException invalidInputException) {
            return offset;
        }
    }
}

