/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.sh.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.dltk.sh.internal.ui.Activator;
import org.eclipse.dltk.sh.internal.ui.ShellContentAssistPreference;
import org.eclipse.dltk.sh.internal.ui.completion.ShellCompletionProcessor;
import org.eclipse.dltk.sh.internal.ui.text.DoubleQuoteScanner;
import org.eclipse.dltk.sh.internal.ui.text.EvalScanner;
import org.eclipse.dltk.sh.internal.ui.text.IShellPartitions;
import org.eclipse.dltk.sh.internal.ui.text.IndentType;
import org.eclipse.dltk.sh.internal.ui.text.ScriptAutoIndentStrategy;
import org.eclipse.dltk.sh.internal.ui.text.ShellCodeScanner;
import org.eclipse.dltk.sh.internal.ui.text.WhitespaceDetector;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptOutlineInformationControl;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.SingleTokenScriptScanner;
import org.eclipse.dltk.ui.text.completion.ContentAssistPreference;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ShellSourceViewerConfiguration
extends ScriptSourceViewerConfiguration {
    private AbstractScriptScanner fCodeScanner;
    private AbstractScriptScanner fCommentScanner;
    private AbstractScriptScanner fDoubleQuoteScanner;
    private AbstractScriptScanner fParamScanner;
    private AbstractScriptScanner fEvalScanner;
    private AbstractScriptScanner fHashbangScanner;
    private AbstractScriptScanner fFunctionScanner;
    private AbstractScriptScanner fSingleQuoteScanner;

    private static IRule getKeywords(IToken keywordToken, String[] words, IToken defaultToken) {
        WordRule wordL = new WordRule(new IWordDetector(){

            public boolean isWordPart(char c) {
                return !Character.isWhitespace(c);
            }

            public boolean isWordStart(char c) {
                return !Character.isWhitespace(c);
            }
        }, defaultToken);
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            wordL.addWord(word, keywordToken);
            ++n2;
        }
        return wordL;
    }

    public ShellSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        ScriptAutoIndentStrategy strategy = new ScriptAutoIndentStrategy();
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add(ShellSourceViewerConfiguration.getKeywords((IToken)new Token((Object)IndentType.INCREMENT), new String[]{"do", "case", "{", "then"}, Token.UNDEFINED));
        rules.add(ShellSourceViewerConfiguration.getKeywords((IToken)new Token((Object)IndentType.DECREMENT), new String[]{"done", "esac", "}", "fi"}, Token.UNDEFINED));
        rules.add(ShellSourceViewerConfiguration.getKeywords((IToken)new Token((Object)IndentType.INFLEXION), new String[]{"else"}, Token.UNDEFINED));
        strategy.setRules(rules.toArray(new IRule[0]));
        return new IAutoEditStrategy[]{strategy};
    }

    protected ContentAssistPreference getContentAssistPreference() {
        return ShellContentAssistPreference.getDefault();
    }

    protected IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new ScriptOutlineInformationControl(parent, shellStyle, treeStyle, commandId, Activator.getDefault().getPreferenceStore());
            }
        };
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ScriptPresentationReconciler reconciler = new ScriptPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fHashbangScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__hashbang");
        reconciler.setRepairer((IPresentationRepairer)dr, "__hashbang");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fParamScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__parameter");
        reconciler.setRepairer((IPresentationRepairer)dr, "__parameter");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fFunctionScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__function");
        reconciler.setRepairer((IPresentationRepairer)dr, "__function");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fSingleQuoteScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__single_quote");
        reconciler.setRepairer((IPresentationRepairer)dr, "__single_quote");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fDoubleQuoteScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__double_quote");
        reconciler.setRepairer((IPresentationRepairer)dr, "__double_quote");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fEvalScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__eval");
        reconciler.setRepairer((IPresentationRepairer)dr, "__eval");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fCommentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__comment");
        return reconciler;
    }

    protected void initializeScanners() {
        this.fCodeScanner = new ShellCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fFunctionScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_function_definition");
        this.fHashbangScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_multi_line_comment");
        this.fSingleQuoteScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_string");
        this.fDoubleQuoteScanner = new DoubleQuoteScanner(this.getColorManager(), this.fPreferenceStore);
        this.fParamScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_argument");
        this.fEvalScanner = new EvalScanner(this.getColorManager(), this.fPreferenceStore);
        this.fCommentScanner = this.createCommentScanner("DLTK_single_line_comment", "DLTK_comment_task_tag");
    }

    protected void alterContentAssistant(ContentAssistant assistant) {
        ShellCompletionProcessor scriptProcessor = new ShellCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)scriptProcessor, "__dftl_partition_content_type");
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fCommentScanner.affectsBehavior(event) || this.fDoubleQuoteScanner.affectsBehavior(event) || this.fSingleQuoteScanner.affectsBehavior(event) || this.fFunctionScanner.affectsBehavior(event) || this.fParamScanner.affectsBehavior(event) || this.fEvalScanner.affectsBehavior(event) || this.fHashbangScanner.affectsBehavior(event);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fCommentScanner.affectsBehavior(event)) {
            this.fCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fDoubleQuoteScanner.affectsBehavior(event)) {
            this.fDoubleQuoteScanner.adaptToPreferenceChange(event);
        }
        if (this.fSingleQuoteScanner.affectsBehavior(event)) {
            this.fSingleQuoteScanner.adaptToPreferenceChange(event);
        }
        if (this.fFunctionScanner.affectsBehavior(event)) {
            this.fFunctionScanner.adaptToPreferenceChange(event);
        }
        if (this.fParamScanner.affectsBehavior(event)) {
            this.fParamScanner.adaptToPreferenceChange(event);
        }
        if (this.fEvalScanner.affectsBehavior(event)) {
            this.fEvalScanner.adaptToPreferenceChange(event);
        }
        if (this.fHashbangScanner.affectsBehavior(event)) {
            this.fHashbangScanner.adaptToPreferenceChange(event);
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return IShellPartitions.CONTENT_TYPES;
    }
}

