/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.rse;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.internal.rse.RSEEnvironment;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class RemoteProjectLabelDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "org.eclipse.dltk.rse.decorators.projectdecorator";

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IProject) {
            this.decorateProjectText((IProject)element, decoration);
        }
    }

    private void decorateProjectText(IProject project, IDecoration decoration) {
        String hostName;
        IEnvironment environment;
        String envId;
        URI uri = project.getLocationURI();
        if (uri != null && "rse".equalsIgnoreCase(uri.getScheme()) && uri.getHost() != null) {
            RemoteProjectLabelDecorator.addHostNameSuffix(decoration, uri.getHost());
        } else if (project.isOpen() && (envId = EnvironmentManager.getEnvironmentId((IProject)project, (boolean)false)) != null && (environment = EnvironmentManager.getEnvironmentById((String)envId)) instanceof RSEEnvironment && (hostName = ((RSEEnvironment)environment).getHost().getHostName()) != null) {
            RemoteProjectLabelDecorator.addHostNameSuffix(decoration, hostName);
            if (!environment.isConnected()) {
                decoration.addSuffix(" [Not connected]");
            }
        }
    }

    private static void addHostNameSuffix(IDecoration decoration, String hostName) {
        decoration.addSuffix(" (" + hostName.toLowerCase() + ")");
    }
}

