/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.MethodCallExpression;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISearchFactory;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.dltk.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.dltk.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.dltk.internal.core.search.matching.MethodPattern;

public class MethodLocator
extends PatternLocator {
    protected MethodPattern pattern;
    protected boolean isDeclarationOfReferencedMethodsPattern;

    public MethodLocator(MethodPattern pattern) {
        super(pattern);
        this.pattern = pattern;
        this.isDeclarationOfReferencedMethodsPattern = this.pattern instanceof DeclarationOfReferencedMethodsPattern;
    }

    protected void clear() {
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
    }

    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        String declaringType;
        if (!this.pattern.findDeclarations) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.getName().toCharArray())) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            List args = node.getArguments();
            int n = argsLength = args == null ? 0 : args.size();
            if (length != argsLength) {
                return 0;
            }
        }
        if (this.checkTypeName(declaringType = node.getDeclaringTypeName())) {
            return 1;
        }
        this.pattern.hasMethodArguments();
        return nodeSet.addMatch(node, 3);
    }

    public int matchContainer() {
        if (this.pattern.findReferences) {
            return 15;
        }
        return 7;
    }

    public SearchMatch newDeclarationMatch(ASTNode reference, IModelElement element, int accuracy, MatchLocator locator) {
        return super.newDeclarationMatch(reference, element, accuracy, locator);
    }

    protected int referenceType() {
        return 9;
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }

    public int match(CallExpression node, MatchingNodeSet nodeSet) {
        MethodCallExpression mce;
        String declaringType;
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (this.pattern.selector == null) {
            return nodeSet.addMatch(node, 2);
        }
        if (this.pattern.declaringSimpleName != null && node instanceof MethodCallExpression && this.checkTypeName(declaringType = (mce = (MethodCallExpression)node).getDeclaringTypeName())) {
            return 1;
        }
        if (this.matchesName(this.pattern.selector, node.getName().toCharArray())) {
            return nodeSet.addMatch(node, 3);
        }
        return 0;
    }

    private boolean checkTypeName(String declaringType) {
        IDLTKLanguageToolkit toolkit = this.pattern.getToolkit();
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(toolkit.getNatureId());
        ISearchPatternProcessor processor = factory.createSearchPatternProcessor();
        if (processor != null && this.pattern.declaringSimpleName != null) {
            char[] delimeter = processor.getDelimeterReplacementString().toCharArray();
            char[] typeName = CharOperation.concatWithSeparator(this.pattern.declaringQualificationName, this.pattern.declaringSimpleName, delimeter);
            typeName = CharOperation.replace(typeName, new char[]{'$'}, delimeter);
            if (declaringType != null) {
                char[] declaringTypeName = declaringType.toCharArray();
                if (!this.matchesName(typeName, declaringTypeName)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

