/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.text.NumberFormat;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.internal.core.Buffer;
import org.eclipse.dltk.internal.core.BufferCache;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OverflowingLRUCache;

public class BufferManager {
    protected static BufferManager DEFAULT_BUFFER_MANAGER;
    protected static boolean VERBOSE;
    protected OverflowingLRUCache openBuffers = new BufferCache(60);

    protected void addBuffer(IBuffer buffer) {
        if (VERBOSE) {
            String owner = ((Openable)buffer.getOwner()).toStringWithAncestors();
            System.out.println("Adding buffer for " + owner);
        }
        this.openBuffers.put(buffer.getOwner(), buffer);
        if (VERBOSE) {
            System.out.println("-> Buffer cache filling ratio = " + NumberFormat.getInstance().format(this.openBuffers.fillingRatio()) + "%");
        }
    }

    public static IBuffer createBuffer(IOpenable owner) {
        IOpenable element = owner;
        IResource resource = element.getResource();
        return new Buffer(resource instanceof IFile ? (IFile)resource : null, owner, element.isReadOnly());
    }

    public IBuffer getBuffer(IOpenable owner) {
        return (IBuffer)this.openBuffers.get(owner);
    }

    public static synchronized BufferManager getDefaultBufferManager() {
        if (DEFAULT_BUFFER_MANAGER == null) {
            DEFAULT_BUFFER_MANAGER = new BufferManager();
        }
        return DEFAULT_BUFFER_MANAGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getOpenBuffers() {
        OverflowingLRUCache overflowingLRUCache = this.openBuffers;
        synchronized (overflowingLRUCache) {
            this.openBuffers.shrink();
            return this.openBuffers.elements();
        }
    }

    protected void removeBuffer(IBuffer buffer) {
        if (VERBOSE) {
            String owner = ((Openable)buffer.getOwner()).toStringWithAncestors();
            System.out.println("Removing buffer for " + owner);
        }
        this.openBuffers.remove(buffer.getOwner());
        if (VERBOSE) {
            System.out.println("-> Buffer cache filling ratio = " + NumberFormat.getInstance().format(this.openBuffers.fillingRatio()) + "%");
        }
    }
}

