/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.index.MixinIndex;
import org.eclipse.dltk.core.search.indexing.SourceIndexer;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.search.DLTKSearchDocument;
import org.eclipse.dltk.internal.core.search.IndexSelector;
import org.eclipse.dltk.internal.core.util.Util;

public class DLTKSearchParticipant
extends SearchParticipant {
    private IndexSelector indexSelector;
    private boolean bSkipMixinIndexes = false;

    public void beginSearching() {
        super.beginSearching();
        this.indexSelector = null;
    }

    public void doneSearching() {
        this.indexSelector = null;
        super.doneSearching();
    }

    public String getDescription() {
        return "DLTK";
    }

    public SearchDocument getDocument(String documentPath) {
        return new DLTKSearchDocument(documentPath, this.getDocumentContents(documentPath), this, this.isExternal(documentPath));
    }

    private boolean isExternal(String documentPath) {
        Object target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IPath)new Path(documentPath), true);
        return !(target instanceof IResource);
    }

    private char[] getDocumentContents(String documentPath) {
        block4: {
            Object target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IPath)new Path(documentPath), true);
            try {
                if (target instanceof IFile) {
                    return Util.getResourceContentsAsCharArray((IFile)target);
                }
                if (target instanceof IFileHandle) {
                    return Util.getResourceContentsAsCharArray((IFileHandle)target);
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return new char[0];
    }

    public void indexDocument(SearchDocument document, IPath indexPath) {
        document.removeAllIndexEntries();
        new SourceIndexer(document).indexDocument();
    }

    public void locateMatches(SearchDocument[] indexMatches, SearchPattern pattern, IDLTKSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        MatchLocator matchLocator = this.createMatchLocator(pattern, requestor, scope, monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locateMatches(indexMatches);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public ISourceModule[] locateModules(SearchDocument[] indexMatches, SearchPattern pattern, IDLTKSearchScope scope, IProgressMonitor monitor) throws CoreException {
        MatchLocator matchLocator = this.createMatchLocator(pattern, null, scope, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 95)));
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ISourceModule[] modules = matchLocator.locateModules(indexMatches);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return modules;
    }

    protected MatchLocator createMatchLocator(SearchPattern pattern, SearchRequestor requestor, IDLTKSearchScope scope, IProgressMonitor monitor) {
        MatchLocator locator;
        IDLTKLanguageToolkit toolkit = scope.getLanguageToolkit();
        if (toolkit != null && (locator = DLTKLanguageManager.createMatchLocator(toolkit.getNatureId(), pattern, requestor, scope, monitor == null ? null : new SubProgressMonitor(monitor, 95))) != null) {
            return locator;
        }
        return new MatchLocator(pattern, requestor, scope, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 95)));
    }

    public IPath[] selectIndexes(SearchPattern pattern, IDLTKSearchScope scope) {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(scope, pattern);
        }
        return this.indexSelector.getIndexLocations();
    }

    public IPath[] selectMixinIndexes(SearchPattern query, IDLTKSearchScope scope) {
        this.skipNotMixin();
        return this.selectIndexes(query, scope);
    }

    public void skipNotMixin() {
        this.bSkipMixinIndexes = true;
    }

    public boolean isSkipped(Index index) {
        if (this.bSkipMixinIndexes) {
            if (index instanceof MixinIndex) {
                return false;
            }
            String containerPath = index.containerPath;
            return !containerPath.startsWith("#special#mixin");
        }
        return false;
    }
}

