/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.internal.testing.model.TestElement;
import org.eclipse.dltk.testing.model.ITestElement;
import org.eclipse.dltk.testing.model.ITestSuiteElement;

public class TestSuiteElement
extends TestElement
implements ITestSuiteElement {
    private List fChildren;
    private TestElement.Status fChildrenStatus;

    public TestSuiteElement(TestSuiteElement parent, String id, String testName, int childrenCount) {
        super(parent, id, testName);
        this.fChildren = new ArrayList(childrenCount);
    }

    public ITestElement.Result getTestResult(boolean includeChildren) {
        if (includeChildren) {
            return this.getStatus().convertToResult();
        }
        return super.getStatus().convertToResult();
    }

    public String getSuiteTypeName() {
        return this.getClassName();
    }

    public ITestElement[] getChildren() {
        return this.fChildren.toArray(new ITestElement[this.fChildren.size()]);
    }

    public void addChild(TestElement child) {
        this.fChildren.add(child);
    }

    public TestElement.Status getStatus() {
        TestElement.Status suiteStatus = this.getSuiteStatus();
        if (this.fChildrenStatus != null) {
            return TestElement.Status.combineStatus(this.fChildrenStatus, suiteStatus);
        }
        return suiteStatus;
    }

    private TestElement.Status getCumulatedStatus() {
        TestElement[] children = this.fChildren.toArray(new TestElement[this.fChildren.size()]);
        if (children.length == 0) {
            return this.getSuiteStatus();
        }
        TestElement.Status cumulated = children[0].getStatus();
        int i = 1;
        while (i < children.length) {
            TestElement.Status childStatus = children[i].getStatus();
            cumulated = TestElement.Status.combineStatus(cumulated, childStatus);
            ++i;
        }
        return cumulated;
    }

    public TestElement.Status getSuiteStatus() {
        return super.getStatus();
    }

    public void childChangedStatus(TestElement child, TestElement.Status childStatus) {
        int childCount = this.fChildren.size();
        if (child == this.fChildren.get(0) && childStatus.isRunning()) {
            this.internalSetChildrenStatus(childStatus);
            return;
        }
        TestElement lastChild = (TestElement)this.fChildren.get(childCount - 1);
        if (child == lastChild) {
            if (childStatus.isDone()) {
                this.internalSetChildrenStatus(this.getCumulatedStatus());
                return;
            }
        } else if (!lastChild.getStatus().isNotRun()) {
            this.internalSetChildrenStatus(this.getCumulatedStatus());
            return;
        }
        if (childStatus.isFailure()) {
            if (this.fChildrenStatus == null || !this.fChildrenStatus.isErrorOrFailure()) {
                this.internalSetChildrenStatus(TestElement.Status.RUNNING_FAILURE);
                return;
            }
        } else if (childStatus.isError() && (this.fChildrenStatus == null || !this.fChildrenStatus.isError())) {
            this.internalSetChildrenStatus(TestElement.Status.RUNNING_ERROR);
            return;
        }
    }

    private void internalSetChildrenStatus(TestElement.Status status) {
        if (this.fChildrenStatus == status) {
            return;
        }
        this.fChildrenStatus = status;
        TestSuiteElement parent = this.getParent();
        if (parent != null) {
            parent.childChangedStatus(this, this.getStatus());
        }
    }

    public String toString() {
        return "TestSuite: " + this.getSuiteTypeName() + " : " + super.toString() + " (" + this.fChildren.size() + ")";
    }
}

