/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.launcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.internal.testing.launcher.ITestKind;
import org.eclipse.dltk.internal.testing.launcher.TestKind;

public class TestKindRegistry {
    private static TestKindRegistry fgRegistry;
    private final IExtensionPoint fPoint;
    private ArrayList fTestKinds;

    public static TestKindRegistry getDefault() {
        if (fgRegistry != null) {
            return fgRegistry;
        }
        fgRegistry = new TestKindRegistry(Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.testing.internal_testKinds"));
        return fgRegistry;
    }

    private TestKindRegistry(IExtensionPoint point) {
        this.fPoint = point;
    }

    public ArrayList getAllKinds() {
        this.loadKinds();
        return this.fTestKinds;
    }

    private void loadKinds() {
        if (this.fTestKinds != null) {
            return;
        }
        ArrayList<TestKind> items = new ArrayList<TestKind>();
        Iterator iter = this.getConfigurationElements().iterator();
        while (iter.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)iter.next();
            items.add(new TestKind(element));
        }
        Collections.sort(items, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                TestKind kind0 = (TestKind)arg0;
                TestKind kind1 = (TestKind)arg1;
                if (kind0.precedes(kind1)) {
                    return -1;
                }
                if (kind1.precedes(kind0)) {
                    return 1;
                }
                return 0;
            }
        });
        this.fTestKinds = items;
    }

    public ArrayList getDisplayNames() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList testTypes = this.getAllKinds();
        Iterator iter = testTypes.iterator();
        while (iter.hasNext()) {
            ITestKind type = (ITestKind)iter.next();
            result.add(type.getDisplayName());
        }
        return result;
    }

    public ITestKind getKind(String testKindId) {
        if (testKindId != null) {
            Iterator iter = this.getAllKinds().iterator();
            while (iter.hasNext()) {
                TestKind kind = (TestKind)iter.next();
                if (!testKindId.equals(kind.getId())) continue;
                return kind;
            }
        }
        return ITestKind.NULL;
    }

    private ArrayList getConfigurationElements() {
        ArrayList<IConfigurationElement> items = new ArrayList<IConfigurationElement>();
        IExtension[] extensions = this.fPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                items.add(element);
                ++j;
            }
            ++i;
        }
        return items;
    }

    public String getAllKindIds() {
        ArrayList allKinds = this.getAllKinds();
        String returnThis = "";
        Iterator iter = allKinds.iterator();
        while (iter.hasNext()) {
            ITestKind kind = (ITestKind)iter.next();
            returnThis = String.valueOf(returnThis) + "(" + kind.getId() + ")";
        }
        return returnThis;
    }
}

