/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.navigator.TreeHierarchyLayoutProblemsDecorator;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.browsing.LogicalPackage;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

class PackagesViewLabelProvider
extends AppearanceAwareLabelProvider {
    static final int HIERARCHICAL_VIEW_STATE = 0;
    static final int FLAT_VIEW_STATE = 1;
    private int fViewState;
    private ImageDescriptorRegistry fRegistry;
    private TreeHierarchyLayoutProblemsDecorator fDecorator;

    PackagesViewLabelProvider(int state) {
        this(state, 564186904002603L, 3);
    }

    PackagesViewLabelProvider(int state, long textFlags, int imageFlags) {
        super(textFlags, imageFlags, DLTKUIPlugin.getDefault().getPreferenceStore());
        Assert.isTrue((boolean)this.isValidState(state));
        this.fViewState = state;
        this.fRegistry = DLTKUIPlugin.getImageDescriptorRegistry();
        this.fDecorator = new TreeHierarchyLayoutProblemsDecorator(this.isFlatView());
        this.addLabelDecorator(this.fDecorator);
    }

    private boolean isValidState(int state) {
        return state == 1 || state == 0;
    }

    public Image getImage(Object element) {
        if (element instanceof LogicalPackage) {
            LogicalPackage cp = (LogicalPackage)((Object)element);
            return this.getLogicalPackageImage(cp);
        }
        return super.getImage(element);
    }

    private Image getLogicalPackageImage(LogicalPackage cp) {
        IScriptFolder[] fragments = cp.getScriptFolders();
        int i = 0;
        while (i < fragments.length) {
            IScriptFolder fragment = fragments[i];
            if (!this.isEmpty(fragment)) {
                return this.decorateCompoundElement(DLTKPluginImages.DESC_OBJS_LOGICAL_PACKAGE, cp);
            }
            ++i;
        }
        return this.decorateCompoundElement(DLTKPluginImages.DESC_OBJS_EMPTY_LOGICAL_PACKAGE, cp);
    }

    private Image decorateCompoundElement(ImageDescriptor imageDescriptor, LogicalPackage cp) {
        Image image = this.fRegistry.get(imageDescriptor);
        return this.decorateImage(image, (Object)cp);
    }

    private boolean isEmpty(IScriptFolder fragment) {
        try {
            return fragment.getSourceModules().length == 0;
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public String getText(Object element) {
        if (element instanceof IScriptFolder) {
            return this.getText((IScriptFolder)element);
        }
        if (element instanceof LogicalPackage) {
            return this.getText((LogicalPackage)((Object)element));
        }
        return super.getText(element);
    }

    private String getText(IScriptFolder fragment) {
        if (this.isFlatView()) {
            return this.getFlatText(fragment);
        }
        return this.getHierarchicalText(fragment);
    }

    private String getText(LogicalPackage logicalPackage) {
        IScriptFolder[] fragments = logicalPackage.getScriptFolders();
        return this.getText(fragments[0]);
    }

    private String getFlatText(IScriptFolder fragment) {
        return super.getText(fragment);
    }

    private boolean isFlatView() {
        return this.fViewState == 1;
    }

    private String getHierarchicalText(IScriptFolder fragment) {
        if (fragment.isRootFolder()) {
            return super.getText(fragment);
        }
        IResource res = fragment.getResource();
        if (res != null && res.getType() != 1) {
            return this.decorateText(res.getName(), fragment);
        }
        return this.decorateText(this.calculateName(fragment), fragment);
    }

    private String calculateName(IScriptFolder fragment) {
        String name = fragment.getElementName();
        if (name.indexOf(".") != -1) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        return name;
    }
}

