/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.model;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.browsing.LogicalPackage;
import org.eclipse.dltk.ui.DLTKUIPlugin;

public abstract class DLTKElementResourceMapping
extends ResourceMapping {
    protected DLTKElementResourceMapping() {
    }

    public IModelElement getModelElement() {
        Object o = this.getModelObject();
        if (o instanceof IModelElement) {
            return (IModelElement)o;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DLTKElementResourceMapping)) {
            return false;
        }
        return this.getModelElement().equals(((DLTKElementResourceMapping)((Object)obj)).getModelElement());
    }

    public int hashCode() {
        IModelElement modelElement = this.getModelElement();
        if (modelElement == null) {
            return super.hashCode();
        }
        return modelElement.hashCode();
    }

    public String getModelProviderId() {
        return "org.eclipse.dltk.ui.modelProvider";
    }

    public boolean contains(ResourceMapping mapping) {
        if (mapping instanceof DLTKElementResourceMapping) {
            DLTKElementResourceMapping javaMapping = (DLTKElementResourceMapping)mapping;
            IModelElement element = this.getModelElement();
            IModelElement other = javaMapping.getModelElement();
            if (other != null && element != null) {
                return element.getPath().isPrefixOf(other.getPath());
            }
        }
        return false;
    }

    private static IFile[] getPackageContent(IScriptFolder pack) throws CoreException {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IContainer container = (IContainer)pack.getResource();
        if (container != null) {
            IResource[] members = container.members();
            int m = 0;
            while (m < members.length) {
                IFile file;
                IResource member = members[m];
                if (!(!(member instanceof IFile) || "class".equals((file = (IFile)member).getFileExtension()) && file.isDerived())) {
                    result.add(member);
                }
                ++m;
            }
        }
        return result.toArray(new IFile[result.size()]);
    }

    public static ResourceMapping create(IModelElement element) {
        switch (element.getElementType()) {
            case 7: {
                return DLTKElementResourceMapping.create((IType)element);
            }
            case 5: {
                return DLTKElementResourceMapping.create((ISourceModule)element);
            }
            case 4: {
                return DLTKElementResourceMapping.create((IScriptFolder)element);
            }
            case 3: {
                return DLTKElementResourceMapping.create((IProjectFragment)element);
            }
            case 2: {
                return DLTKElementResourceMapping.create((IScriptProject)element);
            }
            case 1: {
                return DLTKElementResourceMapping.create((IScriptModel)element);
            }
        }
        return null;
    }

    public static ResourceMapping create(IScriptModel model) {
        return new ScriptModelResourceMapping(model);
    }

    public static ResourceMapping create(IScriptProject project) {
        return new ScriptProjectResourceMapping(project);
    }

    public static ResourceMapping create(IProjectFragment root) {
        if (root.isExternal()) {
            return null;
        }
        return new PackageFragementRootResourceMapping(root);
    }

    public static ResourceMapping create(IScriptFolder pack) {
        IProjectFragment root = (IProjectFragment)pack.getAncestor(3);
        if (!root.isArchive()) {
            return new ScriptFolderResourceMapping(pack);
        }
        return null;
    }

    public static ResourceMapping create(ISourceModule unit) {
        if (unit == null || unit.getResource() == null) {
            return null;
        }
        return new SourceModuleResourceMapping(unit.getPrimary());
    }

    public static ResourceMapping create(IType type) {
        IModelElement parent = type.getParent();
        if (parent instanceof ISourceModule) {
            return DLTKElementResourceMapping.create((ISourceModule)parent);
        }
        return null;
    }

    public static ResourceMapping create(LogicalPackage logicalPackage) {
        IScriptFolder[] fragments = logicalPackage.getFragments();
        ArrayList<IScriptFolder> toProcess = new ArrayList<IScriptFolder>(fragments.length);
        int i = 0;
        while (i < fragments.length) {
            IProjectFragment root = (IProjectFragment)fragments[i].getAncestor(3);
            if (!root.isArchive()) {
                toProcess.add(fragments[i]);
            }
            ++i;
        }
        if (toProcess.size() == 0) {
            return null;
        }
        return new LogicalPackageResourceMapping(toProcess.toArray(new IScriptFolder[toProcess.size()]));
    }

    private static final class LocalPackageFragementTraversal
    extends ResourceTraversal {
        private final IScriptFolder fPack;

        public LocalPackageFragementTraversal(IScriptFolder pack) throws CoreException {
            super(new IResource[]{pack.getResource()}, 1, 0);
            this.fPack = pack;
        }

        public void accept(IResourceVisitor visitor) throws CoreException {
            IFile[] files = DLTKElementResourceMapping.getPackageContent(this.fPack);
            IResource resource = this.fPack.getResource();
            if (resource != null) {
                visitor.visit(resource);
            }
            int i = 0;
            while (i < files.length) {
                visitor.visit((IResource)files[i]);
                ++i;
            }
        }
    }

    private static final class LogicalPackageResourceMapping
    extends ResourceMapping {
        private final IScriptFolder[] fFragments;

        private LogicalPackageResourceMapping(IScriptFolder[] fragments) {
            this.fFragments = fragments;
        }

        public Object getModelObject() {
            return this.fFragments;
        }

        public IProject[] getProjects() {
            HashSet<IProject> result = new HashSet<IProject>();
            int i = 0;
            while (i < this.fFragments.length) {
                result.add(this.fFragments[i].getScriptProject().getProject());
                ++i;
            }
            return result.toArray(new IProject[result.size()]);
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
            if (context instanceof RemoteResourceMappingContext) {
                int i = 0;
                while (i < this.fFragments.length) {
                    result.add(new ResourceTraversal(new IResource[]{this.fFragments[i].getResource()}, 1, 0));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.fFragments.length) {
                    result.add(new LocalPackageFragementTraversal(this.fFragments[i]));
                    ++i;
                }
            }
            return result.toArray(new ResourceTraversal[result.size()]);
        }

        public String getModelProviderId() {
            return "org.eclipse.dltk.ui.modelProvider";
        }
    }

    private static final class PackageFragementRootResourceMapping
    extends DLTKElementResourceMapping {
        private final IProjectFragment fRoot;

        private PackageFragementRootResourceMapping(IProjectFragment root) {
            Assert.isNotNull((Object)root);
            this.fRoot = root;
        }

        public Object getModelObject() {
            return this.fRoot;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fRoot.getScriptProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fRoot.getResource()}, 2, 0)};
        }
    }

    private static final class ScriptFolderResourceMapping
    extends DLTKElementResourceMapping {
        private final IScriptFolder fPack;

        private ScriptFolderResourceMapping(IScriptFolder pack) {
            Assert.isNotNull((Object)pack);
            this.fPack = pack;
        }

        public Object getModelObject() {
            return this.fPack;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fPack.getScriptProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            if (context instanceof RemoteResourceMappingContext) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fPack.getResource()}, 1, 0)};
            }
            if (this.fPack.getResource() != null) {
                return new ResourceTraversal[]{new LocalPackageFragementTraversal(this.fPack)};
            }
            return new ResourceTraversal[0];
        }

        public void accept(ResourceMappingContext context, IResourceVisitor visitor, IProgressMonitor monitor) throws CoreException {
            if (context instanceof RemoteResourceMappingContext) {
                super.accept(context, visitor, monitor);
            } else {
                IFile[] files = DLTKElementResourceMapping.getPackageContent(this.fPack);
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("", files.length + 1);
                IResource resource = this.fPack.getResource();
                if (resource != null) {
                    visitor.visit(resource);
                }
                monitor.worked(1);
                int i = 0;
                while (i < files.length) {
                    visitor.visit((IResource)files[i]);
                    monitor.worked(1);
                    ++i;
                }
            }
        }
    }

    private static final class ScriptModelResourceMapping
    extends DLTKElementResourceMapping {
        private final IScriptModel fModel;

        private ScriptModelResourceMapping(IScriptModel model) {
            Assert.isNotNull((Object)model);
            this.fModel = model;
        }

        public Object getModelObject() {
            return this.fModel;
        }

        public IProject[] getProjects() {
            IScriptProject[] projects = null;
            try {
                projects = this.fModel.getScriptProjects();
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
                return new IProject[0];
            }
            IProject[] result = new IProject[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = projects[i].getProject();
                ++i;
            }
            return result;
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            IScriptProject[] projects = this.fModel.getScriptProjects();
            ResourceTraversal[] result = new ResourceTraversal[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = new ResourceTraversal(new IResource[]{projects[i].getProject()}, 2, 0);
                ++i;
            }
            return result;
        }
    }

    private static final class ScriptProjectResourceMapping
    extends DLTKElementResourceMapping {
        private final IScriptProject fProject;

        private ScriptProjectResourceMapping(IScriptProject project) {
            Assert.isNotNull((Object)project);
            this.fProject = project;
        }

        public Object getModelObject() {
            return this.fProject;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fProject.getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fProject.getProject()}, 2, 0)};
        }
    }

    private static final class SourceModuleResourceMapping
    extends DLTKElementResourceMapping {
        private final ISourceModule fUnit;

        private SourceModuleResourceMapping(ISourceModule unit) {
            Assert.isNotNull((Object)unit);
            this.fUnit = unit;
        }

        public Object getModelObject() {
            return this.fUnit;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fUnit.getScriptProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fUnit.getResource()}, 1, 0)};
        }
    }
}

