/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.dltk.dbgp.IDbgpStatus;

public class DbgpStatus
implements IDbgpStatus {
    public static final Integer REASON_OK = new Integer(0);
    public static final Integer REASON_ERROR = new Integer(1);
    public static final Integer REASON_ABORTED = new Integer(2);
    public static final Integer REASON_EXCEPTION = new Integer(3);
    public static final Integer STATUS_STARTING = new Integer(0);
    public static final Integer STATUS_STOPPING = new Integer(1);
    public static final Integer STATUS_STOPPED = new Integer(2);
    public static final Integer STATUS_RUNNING = new Integer(3);
    public static final Integer STATUS_BREAK = new Integer(4);
    public static Map statusParser = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    public static Map reasonParser = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final Integer status;
    private final Integer reason;

    static {
        statusParser.put("starting", STATUS_STARTING);
        statusParser.put("stopping", STATUS_STOPPING);
        statusParser.put("stopped", STATUS_STOPPED);
        statusParser.put("running", STATUS_RUNNING);
        statusParser.put("break", STATUS_BREAK);
        reasonParser.put("ok", REASON_OK);
        reasonParser.put("error", REASON_ERROR);
        reasonParser.put("aborted", REASON_ABORTED);
        reasonParser.put("exception", REASON_EXCEPTION);
    }

    public static IDbgpStatus parse(String status, String reason) {
        return new DbgpStatus((Integer)statusParser.get(status), (Integer)reasonParser.get(reason));
    }

    public DbgpStatus(Integer status, Integer reason) {
        if (status == null) {
            throw new IllegalArgumentException();
        }
        if (reason == null) {
            throw new IllegalArgumentException();
        }
        this.status = status;
        this.reason = reason;
    }

    public boolean reasonAborred() {
        return REASON_ABORTED == this.reason;
    }

    public boolean reasonError() {
        return REASON_ERROR == this.reason;
    }

    public boolean reasonException() {
        return REASON_EXCEPTION == this.reason;
    }

    public boolean reasonOk() {
        return REASON_OK == this.reason;
    }

    public boolean isRunning() {
        return STATUS_RUNNING == this.status;
    }

    public boolean isStarting() {
        return STATUS_STARTING == this.status;
    }

    public boolean isStopped() {
        return STATUS_STOPPED == this.status;
    }

    public boolean isStopping() {
        return STATUS_STOPPING == this.status;
    }

    public boolean isBreak() {
        return STATUS_BREAK == this.status;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DbgpStatus) {
            DbgpStatus s = (DbgpStatus)obj;
            return this.status == s.status || this.reason == s.reason;
        }
        return false;
    }

    public int hashCode() {
        return this.status.hashCode() << 8 | this.reason.hashCode();
    }

    public String toString() {
        return "Status: " + this.status.toString() + "; Reason: " + this.reason.toString();
    }
}

