/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.dltk.console.InterpreterResponse;
import org.eclipse.dltk.console.ScriptConsoleCompletionProposal;
import org.eclipse.dltk.console.ShellResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ScriptConsoleXmlHelper {
    private ScriptConsoleXmlHelper() {
    }

    protected static int convertState(String state) {
        if (state.equals("new")) {
            return 0;
        }
        if (state.equals("continue")) {
            return 1;
        }
        if (state.equals("user")) {
            return 2;
        }
        return -1;
    }

    protected static boolean isElement(Node node, String name) {
        return node.getNodeType() == 1 && node.getNodeName().equals(name);
    }

    protected static String getAttrib(NamedNodeMap attribs, String name) {
        return attribs.getNamedItem(name).getNodeValue();
    }

    protected static Document parse(String xml) {
        if (xml == null || xml.length() == 0) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            StringReader reader = new StringReader(xml);
            InputSource source = new InputSource(reader);
            source.setEncoding("UTF-8");
            return builder.parse(source);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static List parseCompletionList(Node completionNode) {
        NodeList children = completionNode.getChildNodes();
        ArrayList<ScriptConsoleCompletionProposal> completions = new ArrayList<ScriptConsoleCompletionProposal>();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (ScriptConsoleXmlHelper.isElement(node, "case")) {
                Element element = (Element)node;
                String display = element.getAttribute("display");
                String insert = element.getAttribute("insert");
                String type = element.getAttribute("type");
                completions.add(new ScriptConsoleCompletionProposal(insert, display, type));
            }
            ++i;
        }
        return completions;
    }

    public static String parseInfoXml(String xml) {
        Document doc = ScriptConsoleXmlHelper.parse(xml);
        if (doc == null) {
            return null;
        }
        NodeList list = doc.getElementsByTagName("console");
        Node node = list.item(0);
        list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (ScriptConsoleXmlHelper.isElement(n, "info")) {
                return ((Element)n).getAttribute("id");
            }
            ++i;
        }
        return null;
    }

    public static ShellResponse parseShellXml(String xml) {
        Document doc = ScriptConsoleXmlHelper.parse(xml);
        if (doc == null) {
            return null;
        }
        NodeList list1 = doc.getElementsByTagName("console");
        Node node = list1.item(0);
        list1 = node.getChildNodes();
        int i = 0;
        while (i < list1.getLength()) {
            Node n1 = list1.item(i);
            if (ScriptConsoleXmlHelper.isElement(n1, "shell")) {
                NodeList list2 = n1.getChildNodes();
                int j = 0;
                while (j < list2.getLength()) {
                    Node n2 = list2.item(j);
                    if (ScriptConsoleXmlHelper.isElement(n2, "completion")) {
                        List completions = ScriptConsoleXmlHelper.parseCompletionList(n2);
                        return new ShellResponse(completions);
                    }
                    if (ScriptConsoleXmlHelper.isElement(n2, "description")) {
                        if (n2.getChildNodes().getLength() == 0) {
                            return new ShellResponse("");
                        }
                        return new ShellResponse(n2.getFirstChild().getNodeValue());
                    }
                    if (ScriptConsoleXmlHelper.isElement(n2, "close")) {
                        return new ShellResponse();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static InterpreterResponse parseInterpreterXml(String xml) {
        Document doc = ScriptConsoleXmlHelper.parse(xml);
        if (doc == null) {
            return null;
        }
        NodeList list = doc.getElementsByTagName("console").item(0).getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (ScriptConsoleXmlHelper.isElement(n, "interpreter")) {
                String state = ScriptConsoleXmlHelper.getAttrib(n.getAttributes(), "state");
                String response = "";
                if (n.getChildNodes().getLength() > 0) {
                    response = n.getFirstChild().getNodeValue();
                }
                return new InterpreterResponse(ScriptConsoleXmlHelper.convertState(state), response);
            }
            ++i;
        }
        return null;
    }
}

