/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal.listeners;

import jakarta.inject.Named;
import java.text.NumberFormat;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.annotations.lifecycle.BeginTask;
import org.eclipse.tea.core.annotations.lifecycle.BeginTaskChain;
import org.eclipse.tea.core.annotations.lifecycle.FinishTask;
import org.eclipse.tea.core.annotations.lifecycle.FinishTaskChain;
import org.eclipse.tea.core.internal.TaskProgressEstimationService;
import org.eclipse.tea.core.internal.TimeHelper;
import org.eclipse.tea.core.internal.config.CoreConfig;
import org.eclipse.tea.core.internal.listeners.TaskingStatusTracker;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.services.TaskingLifeCycleListener;
import org.eclipse.tea.core.services.TaskingLog;
import org.osgi.service.component.annotations.Component;

@TaskingLifeCycleListener.TaskingLifeCyclePriority(value=90)
@Component
public class LifecycleAnnouncer
implements TaskingLifeCycleListener {
    private static final int WIDTH = 100;
    private long startTime = 0L;

    @BeginTaskChain
    public void beginChain(TaskingLog log, CoreConfig config, TaskExecutionContext context, TaskChain chain) {
        log.info(this.header(config, "CHAIN START " + TaskingModel.getTaskChainName(chain)));
        this.measureMemoryUsage(log, config);
        this.startTime = System.currentTimeMillis();
    }

    @FinishTaskChain
    public void finishChain(TaskingLog log, CoreConfig config, TaskExecutionContext context, MultiStatus result, @Named(value="org.eclipse.tea.core.prepared_tasks") List<Object> allTasks, TaskingStatusTracker tracker) {
        log.info(this.header(config, "Results"));
        for (Object task : allTasks) {
            String nameStatus = this.readableStatus(tracker.getStatus(context, task)) + " " + TaskingModel.getTaskName(task) + ": ";
            log.info(nameStatus + this.fillLeft(config, TimeHelper.formatDetailedDuration(tracker.getDuration(context, task)), ' ', 100 - nameStatus.length()));
        }
        log.info(this.separator(config));
        String msg = "TOTAL (" + (result.getSeverity() < 4 ? "SUCCESS" : "FAILED") + "): ";
        log.info(msg + this.fillLeft(config, TimeHelper.formatDuration(System.currentTimeMillis() - this.startTime), ' ', 100 - msg.length()));
    }

    @BeginTask
    public void beginTask(TaskingLog log, CoreConfig config, @Named(value="org.eclipse.tea.core.task") Object task, @Optional @Service TaskProgressEstimationService svc) {
        String id;
        String string = id = svc == null ? null : svc.calculateId(task);
        if (id != null) {
            log.info(this.header(config, "(  GO  ) " + TaskingModel.getTaskName(task) + " [ETA: " + TimeHelper.formatDetailedDuration(svc.getEstimatedMillis(id)) + "]"));
        } else {
            log.info(this.header(config, "(  GO  ) " + TaskingModel.getTaskName(task)));
        }
    }

    @FinishTask
    public void finishTask(TaskingLog log, CoreConfig config, @Named(value="org.eclipse.tea.core.task") Object task, IStatus taskStatus) {
        this.measureMemoryUsage(log, config);
        log.info(this.header(config, this.readableStatus(taskStatus) + " " + TaskingModel.getTaskName(task)));
        if (taskStatus.getException() != null && taskStatus.getSeverity() != 8) {
            log.error("Error while executing task", taskStatus.getException());
        }
    }

    private String readableStatus(IStatus s) {
        if (s == null) {
            return "(      )";
        }
        switch (s.getSeverity()) {
            case 8: {
                return "(CANCEL)";
            }
            case 4: {
                if (s.getException() != null) {
                    return "( EXCPT)";
                }
                return "( ERROR)";
            }
            case 1: {
                return "( INFO )";
            }
            case 2: {
                return "( WARN )";
            }
            case 0: {
                return "(  OK  )";
            }
        }
        return "(      )";
    }

    private void measureMemoryUsage(TaskingLog log, CoreConfig config) {
        if (!config.measureMemoryUsage.booleanValue()) {
            return;
        }
        System.gc();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        long availableMemory = maxMemory - usedMemory;
        NumberFormat format = NumberFormat.getNumberInstance();
        String msg = "used memory=" + format.format(LifecycleAnnouncer.bytesToMega(usedMemory)) + "M, available memory=" + format.format(LifecycleAnnouncer.bytesToMega(availableMemory)) + "M";
        log.debug(msg);
    }

    private static long bytesToMega(long bytes) {
        return bytes / 0x100000L;
    }

    private String fillRight(CoreConfig config, String s, char pad, int length) {
        if (s.length() >= length || config.useAccessibleMode.booleanValue()) {
            return s;
        }
        return s + this.getPaddedString(pad, length - s.length());
    }

    private String fillLeft(CoreConfig config, String s, char pad, int length) {
        if (s.length() >= length || config.useAccessibleMode.booleanValue()) {
            return s;
        }
        return this.getPaddedString(pad, length - s.length()) + s;
    }

    private String getPaddedString(char pad, int length) {
        return String.format("%" + length + "s", Character.valueOf(pad)).replace(' ', pad);
    }

    private String header(CoreConfig cfg, String s) {
        if (cfg.useAccessibleMode.booleanValue()) {
            return s;
        }
        return this.fillLeft(cfg, " " + s + " ---", '-', 100);
    }

    private String separator(CoreConfig config) {
        return this.fillRight(config, "-", '-', 100);
    }
}

