/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;

@NonNullByDefault
public class CtrlReport
implements RJIOExternalizable {
    private static final int REQUEST_EXECUTED = 0x1000000;
    private static final int ENGINE_EXECUTING = 0;
    private static final int ENGINE_SUSPENDED = 0x2000000;
    private static final int RESET_PROMPT = 0x100000;
    private final int code;

    public static CtrlReport createRequestExecuted(byte type) {
        switch (type) {
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                return new CtrlReport(type | 0x1000000);
            }
        }
        throw new IllegalArgumentException("type= " + type);
    }

    public static CtrlReport createRequestNotApplicable(boolean isEngineSuspended) {
        return new CtrlReport(isEngineSuspended ? 0x2000000 : 0);
    }

    public static CtrlReport createRequestNotSupported(boolean isEngineSuspended) {
        return new CtrlReport(isEngineSuspended ? 0x2000000 : 0);
    }

    private CtrlReport(int code) {
        this.code = code;
    }

    public CtrlReport(RJIO io) throws IOException {
        this.code = io.readInt();
    }

    public void writeExternal(RJIO io) throws IOException {
        io.writeInt(this.code);
    }

    public byte getOp() {
        return (byte)(this.code & 0xFF);
    }

    public boolean isRequestExecuted() {
        return (this.code & 0x1000000) != 0;
    }

    public boolean isEngineSuspended() {
        return (this.code & 0x2000000) != 0;
    }
}

