/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.internal.yaml.core.model.BasicYamlSourceElement;
import org.eclipse.statet.internal.yaml.core.model.CompositeSourceElement;
import org.eclipse.statet.internal.yaml.core.model.ContainerSourceElement;
import org.eclipse.statet.internal.yaml.core.model.ElementNameCreator;
import org.eclipse.statet.internal.yaml.core.model.TermElement;
import org.eclipse.statet.internal.yaml.core.model.YamlSourceUnitModelInfoImpl;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.yaml.core.model.YamlChunkElement;
import org.eclipse.statet.yaml.core.model.YamlElementName;
import org.eclipse.statet.yaml.core.model.YamlSourceElement;
import org.eclipse.statet.yaml.core.model.YamlSourceUnitModelInfo;
import org.eclipse.statet.yaml.core.source.ast.DocumentNode;
import org.eclipse.statet.yaml.core.source.ast.MapEntry;
import org.eclipse.statet.yaml.core.source.ast.NodeType;
import org.eclipse.statet.yaml.core.source.ast.NodeWithProperties;
import org.eclipse.statet.yaml.core.source.ast.SeqEntry;
import org.eclipse.statet.yaml.core.source.ast.SourceComponent;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;

@NonNullByDefault
public class SourceAnalyzer {
    private SourceUnit sourceUnit = (SourceUnit)ObjectUtils.nonNullLateInit();
    private AstInfo ast = (AstInfo)ObjectUtils.nonNullLateInit();
    private @Nullable List<YamlChunkElement> chunkElements;
    private final ElementNameCreator nameCreator = new ElementNameCreator();
    private final List<ArrayList<YamlSourceElement>> containerBuilderStack = new ArrayList<ArrayList<YamlSourceElement>>();
    private int depth = -1;

    /*
     * Unable to fully structure code
     */
    public YamlSourceUnitModelInfoImpl createModel(SourceUnit sourceUnit, AstInfo ast) {
        try {
            this.sourceUnit = sourceUnit;
            this.ast = ast;
            rootNode = (SourceComponent)ast.getRoot();
            element = new ContainerSourceElement.SourceContainer(this.sourceUnit, ast.getStamp(), rootNode);
            this.processSourceLines(element, rootNode);
            var7_6 = modelInfo = new YamlSourceUnitModelInfoImpl(ast, element);
            ** while (this.depth >= 0)
        }
        catch (Throwable var6_7) {
            ** while (this.depth >= 0)
        }
lbl-1000:
        // 1 sources

        {
            this.containerBuilderStack.get(this.depth--).clear();
            continue;
        }
lbl11:
        // 1 sources

        return var7_6;
lbl-1000:
        // 1 sources

        {
            this.containerBuilderStack.get(this.depth--).clear();
            continue;
        }
lbl16:
        // 1 sources

        throw var6_7;
    }

    public void beginChunkSession(SourceUnit sourceUnit, AstInfo ast) {
        this.sourceUnit = sourceUnit;
        this.ast = ast;
        if (this.chunkElements == null) {
            this.chunkElements = new ArrayList<YamlChunkElement>();
        }
    }

    public void processChunk(YamlChunkElement element, SourceComponent sourceComponent) {
        List chunkElements = (List)ObjectUtils.nonNullAssert(this.chunkElements);
        chunkElements.add(element);
        this.processSourceLines(element, sourceComponent);
    }

    public YamlSourceUnitModelInfo stopChunkSession() {
        List chunkElements = (List)ObjectUtils.nonNullAssert(this.chunkElements);
        try {
            CompositeSourceElement compositeElement = new CompositeSourceElement(this.sourceUnit, this.ast.getStamp(), chunkElements, (TextRegion)this.ast.getRoot());
            YamlSourceUnitModelInfoImpl yamlSourceUnitModelInfoImpl = new YamlSourceUnitModelInfoImpl(this.ast, compositeElement);
            return yamlSourceUnitModelInfoImpl;
        }
        finally {
            this.sourceUnit = null;
            chunkElements.clear();
        }
    }

    private List<YamlSourceElement> enter(ContainerSourceElement element) {
        ArrayList<YamlSourceElement> containerBuilder;
        int depth;
        if ((depth = ++this.depth) < this.containerBuilderStack.size()) {
            containerBuilder = this.containerBuilderStack.get(depth);
        } else {
            containerBuilder = new ArrayList();
            this.containerBuilderStack.add(containerBuilder);
        }
        return containerBuilder;
    }

    private void exit(ContainerSourceElement element, List<YamlSourceElement> builder) {
        element.children = ImCollections.concatList(element.children, builder);
        builder.clear();
        --this.depth;
    }

    private void processSourceLines(ContainerSourceElement element, SourceComponent sourceComponent) {
        List<YamlSourceElement> builder = this.enter(element);
        int docCount = element.children.size();
        int childIndex = 0;
        while (childIndex < sourceComponent.getChildCount()) {
            YamlAstNode childNode = sourceComponent.getChild(childIndex);
            if (childNode instanceof DocumentNode) {
                BasicYamlSourceElement childElement = this.createDocumentElement(element, (DocumentNode)childNode);
                childElement.occurrenceCount = docCount++;
                childElement.name = YamlElementName.create(81, Integer.toString(childElement.occurrenceCount + 1));
                builder.add(childElement);
            }
            ++childIndex;
        }
        this.exit(element, builder);
    }

    private BasicYamlSourceElement createDocumentElement(ContainerSourceElement parent, DocumentNode node) {
        ContainerSourceElement.CollectionContainer element = new ContainerSourceElement.CollectionContainer(1040, parent, node, node);
        List<YamlSourceElement> builder = this.enter(element);
        ImIdentityList<YamlAstNode> contentNodes = node.getContentNodes();
        int childIndex = 0;
        while (childIndex < contentNodes.size()) {
            YamlAstNode childNode = (YamlAstNode)((Object)contentNodes.get(childIndex));
            BasicYamlSourceElement childElement = this.createContentElement(parent, childNode);
            childElement.occurrenceCount = childIndex++;
            childElement.name = YamlElementName.create(15, "");
            builder.add(childElement);
        }
        this.exit(element, builder);
        return element;
    }

    /*
     * WARNING - void declaration
     */
    private BasicYamlSourceElement createContentElement(ContainerSourceElement parent, YamlAstNode node) {
        YamlAstNode contentNode = node;
        switch (node.getNodeType()) {
            case SEQ_ENTRY: {
                if (node.getYamlParent().getNodeType() != NodeType.SEQ) break;
                contentNode = ((SeqEntry)node).getValue();
                break;
            }
            case MAP_ENTRY: {
                if (node.getYamlParent().getNodeType() != NodeType.MAP) break;
                contentNode = ((MapEntry)node).getValue();
                break;
            }
        }
        if (contentNode.getNodeType() == NodeType.PROPERTIES_CONTAINER) {
            contentNode = ((NodeWithProperties)node).getNode();
        }
        switch (contentNode.getNodeType()) {
            case SEQ: {
                ContainerSourceElement.CollectionContainer element = new ContainerSourceElement.CollectionContainer(2560, parent, node, contentNode);
                if (this.depth <= 2 || this.hasNonScalarChild(contentNode)) {
                    List<YamlSourceElement> builder = this.enter(element);
                    int childIndex = 0;
                    while (childIndex < contentNode.getChildCount()) {
                        BasicYamlSourceElement childElement;
                        YamlAstNode childNode = contentNode.getChild(childIndex);
                        if (childNode instanceof MapEntry) {
                            childElement = this.createContentElement(element, childNode);
                            childElement.name = this.nameCreator.createSeqEntry(childIndex);
                        } else {
                            childElement = this.createContentElement(element, childNode);
                            childElement.name = this.nameCreator.createSeqEntry(childIndex);
                        }
                        builder.add(childElement);
                        ++childIndex;
                    }
                    this.exit(element, builder);
                }
                return element;
            }
            case MAP: {
                ContainerSourceElement.CollectionContainer element = new ContainerSourceElement.CollectionContainer(2576, parent, node, contentNode);
                List<YamlSourceElement> builder = this.enter(element);
                int childIndex = 0;
                while (childIndex < contentNode.getChildCount()) {
                    BasicYamlSourceElement childElement;
                    YamlAstNode childNode = contentNode.getChild(childIndex);
                    YamlAstNode yamlAstNode = childNode;
                    if (yamlAstNode instanceof MapEntry) {
                        void entry;
                        MapEntry cfr_ignored_0 = (MapEntry)yamlAstNode;
                        MapEntry cfr_ignored_1 = (MapEntry)yamlAstNode;
                        childElement = this.createContentElement(element, childNode);
                        childElement.name = this.nameCreator.createMapKey(entry.getKey());
                        childElement.nameRegion = entry.getKey();
                    } else {
                        childElement = this.createContentElement(element, childNode);
                        childElement.name = this.nameCreator.createMapKey(null);
                    }
                    builder.add(childElement);
                    ++childIndex;
                }
                this.exit(element, builder);
                return element;
            }
            case SCALAR: {
                return new TermElement(2816, parent, node);
            }
            case ALIAS: {
                return new TermElement(3584, parent, node);
            }
            case ERROR: {
                return new TermElement(3840, parent, node);
            }
        }
        return new TermElement(0, parent, node);
    }

    private boolean hasNonScalarChild(YamlAstNode node) {
        int childIndex = 0;
        while (childIndex < node.getChildCount()) {
            YamlAstNode child = node.getChild(childIndex);
            switch (child.getNodeType()) {
                case PROPERTIES_CONTAINER: 
                case MAP: {
                    return true;
                }
                case SEQ: 
                case SEQ_ENTRY: 
                case MAP_ENTRY: {
                    if (!this.hasNonScalarChild(child)) break;
                    return true;
                }
            }
            ++childIndex;
        }
        return false;
    }
}

