/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core;

import java.util.List;
import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.internal.yaml.core.YamlCorePlugin;
import org.eclipse.statet.internal.yaml.core.model.SourceAnalyzer;
import org.eclipse.statet.internal.yaml.core.model.YamlModelManagerImpl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.core.source.SourceModelStamp;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.model.core.build.SourceUnitIssueSupport;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.BasicSourceModelStamp;
import org.eclipse.statet.ltk.project.core.LtkProject;
import org.eclipse.statet.yaml.core.model.YamlChunkElement;
import org.eclipse.statet.yaml.core.model.YamlSourceUnitModelInfo;
import org.eclipse.statet.yaml.core.model.build.YamlIssueReporter;
import org.eclipse.statet.yaml.core.model.build.YamlSourceUnitModelContainer;
import org.eclipse.statet.yaml.core.source.ast.SourceComponent;
import org.eclipse.statet.yaml.core.source.ast.YamlParser;

@NonNullByDefault
public class YamlReconciler {
    private final YamlModelManagerImpl yamlManager;
    protected boolean stop = false;
    private final Object raLock = new Object();
    private final YamlParser raParser = new YamlParser();
    private final Object rmLock = new Object();
    private final SourceAnalyzer rmSourceAnalyzer = new SourceAnalyzer();
    private final Object riLock = new Object();
    private final YamlIssueReporter riReporter = new YamlIssueReporter();
    private LtkProject project;
    private @Nullable MultiStatus statusCollector;

    public YamlReconciler(YamlModelManagerImpl manager) {
        this.yamlManager = manager;
    }

    public void init(LtkProject project, MultiStatus statusCollector) {
        this.project = (LtkProject)ObjectUtils.nonNullAssert((Object)project);
        this.statusCollector = statusCollector;
    }

    void stop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile(YamlSourceUnitModelContainer adapter, int flags, IProgressMonitor monitor) {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
        Data data = new Data(adapter, m);
        if (data == null || !data.isOK()) {
            adapter.clear();
            return;
        }
        if (this.stop || m.isCanceled()) {
            throw new CancellationException();
        }
        Object object = this.raLock;
        synchronized (object) {
            if (this.stop || m.isCanceled()) {
                throw new CancellationException();
            }
            this.updateAst(data, flags);
        }
        if (this.stop || m.isCanceled()) {
            throw new CancellationException();
        }
        if ((flags & 0xF) < 2) {
            return;
        }
        object = this.rmLock;
        synchronized (object) {
            if (this.stop || m.isCanceled()) {
                throw new CancellationException();
            }
            boolean updated = this.updateModel(data, flags, m);
            if (updated) {
                this.yamlManager.getEventJob().addUpdate((LtkModelElement)data.sourceUnit, data.oldModel, data.newModel);
            }
        }
        if ((flags & 0x2000000) != 0 && data.newModel != null) {
            object = this.riLock;
            synchronized (object) {
                if (this.stop || m.isCanceled() || data.newModel != data.adapter.getCurrentModel()) {
                    return;
                }
                this.reportIssues(data, flags);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YamlSourceUnitModelInfo reconcile(SourceUnit su, SourceUnitModelInfo modelInfo, List<? extends YamlChunkElement> chunkElements, int level, IProgressMonitor monitor) {
        Object object = this.rmLock;
        synchronized (object) {
            return this.updateModel(su, modelInfo, chunkElements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateAst(Data data, int flags) {
        BasicSourceModelStamp stamp = new BasicSourceModelStamp(data.content.getStamp());
        AstInfo ast = data.adapter.getCurrentAst();
        if (ast != null && !stamp.equals((Object)ast.getStamp())) {
            ast = null;
        }
        if (ast != null) {
            data.ast = ast;
        } else {
            this.raParser.setScalarText(true);
            this.raParser.setCommentLevel(1);
            SourceComponent sourceNode = this.raParser.parseSourceUnit(data.content.getString(), data.content.getStartOffset(), null);
            ast = new AstInfo(1, (SourceModelStamp)stamp, (AstNode)sourceNode);
            YamlSourceUnitModelContainer yamlSourceUnitModelContainer = data.adapter;
            synchronized (yamlSourceUnitModelContainer) {
                data.adapter.setAst(ast);
            }
            data.ast = ast;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateModel(Data data, int flags, SubMonitor m) {
        boolean isOK;
        YamlSourceUnitModelInfo model = (YamlSourceUnitModelInfo)data.adapter.getCurrentModel();
        if (model != null && !data.getAst().getStamp().equals(model.getStamp())) {
            model = null;
        }
        if (model != null) {
            data.newModel = model;
            return false;
        }
        model = this.rmSourceAnalyzer.createModel(data.adapter.getSourceUnit(), data.getAst());
        boolean bl = isOK = model != null;
        if (isOK) {
            YamlSourceUnitModelContainer yamlSourceUnitModelContainer = data.adapter;
            synchronized (yamlSourceUnitModelContainer) {
                data.oldModel = (YamlSourceUnitModelInfo)data.adapter.getCurrentModel();
                data.adapter.setModel(model);
            }
            data.newModel = model;
            return true;
        }
        return false;
    }

    private YamlSourceUnitModelInfo updateModel(SourceUnit sourceUnit, SourceUnitModelInfo modelInfo, List<? extends YamlChunkElement> chunkElements) {
        YamlSourceUnitModelInfo model;
        try {
            AstInfo ast = modelInfo.getAst();
            this.rmSourceAnalyzer.beginChunkSession(sourceUnit, ast);
            for (YamlChunkElement yamlChunkElement : chunkElements) {
                SourceComponent rootNode = yamlChunkElement.getAdapter(SourceComponent.class);
                if (rootNode == null) continue;
                this.rmSourceAnalyzer.processChunk(yamlChunkElement, rootNode);
            }
        }
        finally {
            model = this.rmSourceAnalyzer.stopChunkSession();
        }
        return model;
    }

    protected void reportIssues(Data data, int flags) {
        block6: {
            try {
                SourceUnitIssueSupport issueSupport = data.adapter.getIssueSupport();
                if (issueSupport == null) {
                    return;
                }
                IssueRequestor issueRequestor = issueSupport.createIssueRequestor(data.sourceUnit);
                if (issueRequestor == null) break block6;
                try {
                    this.riReporter.run(data.sourceUnit, data.getModel(), data.content, issueRequestor, flags);
                }
                finally {
                    issueRequestor.finish();
                }
            }
            catch (Exception e) {
                this.handleStatus((IStatus)new Status(4, "org.eclipse.statet.yaml.core", 0, String.format("An error occurred when reporting issues for source unit %1$s.", data.sourceUnit), (Throwable)e));
            }
        }
    }

    protected void handleStatus(IStatus status) {
        MultiStatus collector = this.statusCollector;
        if (collector != null) {
            collector.add(status);
        } else {
            YamlCorePlugin.log(status);
        }
    }

    protected static final class Data {
        public final YamlSourceUnitModelContainer adapter;
        public final SourceUnit sourceUnit;
        public final SourceContent content;
        @Nullable AstInfo ast;
        @Nullable YamlSourceUnitModelInfo oldModel;
        @Nullable YamlSourceUnitModelInfo newModel;

        public Data(YamlSourceUnitModelContainer adapter, SubMonitor monitor) {
            this.adapter = adapter;
            this.sourceUnit = adapter.getSourceUnit();
            this.content = adapter.getParseContent((IProgressMonitor)monitor);
        }

        boolean isOK() {
            return this.content != null;
        }

        public AstInfo getAst() {
            return this.ast;
        }

        public YamlSourceUnitModelInfo getModel() {
            return this.newModel;
        }
    }
}

