/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.dataeditor;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.ui.dataeditor.RDataEditorInput;
import org.eclipse.statet.r.ui.dataeditor.RToolDataTableInput;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.ui.IPersistableElement;

@NonNullByDefault
public class RLiveDataEditorInput
extends PlatformObject
implements RDataEditorInput {
    private final RToolDataTableInput input;

    public static boolean isSupported(RObject element) {
        switch (element.getRObjectType()) {
            case 2: 
            case 6: {
                return true;
            }
            case 3: {
                return ((RArray)element).getDim().getLength() == 2L;
            }
        }
        return false;
    }

    public RLiveDataEditorInput(RElementName elementName, FQRObjectRef<? extends RTool> elementRef) {
        this.input = new RToolDataTableInput(elementName, elementRef);
    }

    public @Nullable ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.input.getName();
    }

    public String getToolTipText() {
        return NLS.bind((String)"{0} in {1}", (Object)this.input.getElementName().getDisplayName(), (Object)this.input.getTool().getLabel(1));
    }

    public boolean exists() {
        return this.input.isAvailable();
    }

    public @Nullable IPersistableElement getPersistable() {
        return null;
    }

    @Override
    public RToolDataTableInput getRDataTableInput() {
        return this.input;
    }

    public int hashCode() {
        return this.input.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RLiveDataEditorInput) {
            return this.input.equals(((RLiveDataEditorInput)obj).input);
        }
        return false;
    }
}

