/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.config;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigPresets;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigTabWithDbc;
import org.eclipse.statet.ecommons.ui.components.DropDownButton;
import org.eclipse.statet.internal.ecommons.debug.ui.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public abstract class LaunchConfigTabWithPresets
extends LaunchConfigTabWithDbc {
    private ImList<ILaunchConfiguration> presets = ImCollections.emptyList();
    private @Nullable Map<String, Object> presetToLoad;
    private @Nullable ILaunchConfiguration presetLoaded;

    protected LaunchConfigTabWithPresets() {
    }

    protected void setPresets(LaunchConfigPresets presets) {
        this.presets = presets.toList();
    }

    protected DropDownButton addPresetsButton(Composite parent) {
        DropDownButton button = new DropDownButton(parent, 4);
        button.setText(Messages.ConfigTab_LoadPreset_label);
        GridData gd = new GridData(131072, 4, true, false);
        button.setLayoutData((Object)gd);
        Menu menu = button.getDropDownMenu();
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchConfigTabWithPresets.this.loadPreset((ILaunchConfiguration)e.widget.getData());
            }
        };
        for (ILaunchConfiguration preset : this.presets) {
            MenuItem item = new MenuItem(menu, 8);
            item.setText(LaunchConfigPresets.getName(preset));
            item.setData((Object)preset);
            item.addSelectionListener((SelectionListener)selectionListener);
        }
        if (this.presets.isEmpty()) {
            button.setEnabled(false);
        }
        return button;
    }

    protected ImList<ILaunchConfigurationTab> getPresetTabs(ILaunchConfiguration config) {
        Object[] tabs = this.getLaunchConfigurationDialog().getTabs();
        if (tabs != null && tabs[tabs.length - 1] instanceof CommonTab) {
            return ImCollections.newList((Object[])tabs, (int)0, (int)(tabs.length - 1));
        }
        return ImCollections.newList();
    }

    protected void loadPreset(ILaunchConfiguration preset) {
        try {
            try {
                this.presetToLoad = preset.getAttributes();
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
                ILaunchConfiguration config = this.presetLoaded;
                if (config != null) {
                    ImList<ILaunchConfigurationTab> tabs = this.getPresetTabs(config);
                    for (ILaunchConfigurationTab tab : tabs) {
                        tab.initializeFrom(config);
                    }
                }
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", 0, "An error occurred while loading the launch configuration preset.", (Throwable)e), 3);
                this.presetToLoad = null;
                this.presetLoaded = null;
            }
        }
        finally {
            this.presetToLoad = null;
            this.presetLoaded = null;
        }
    }

    @Override
    protected void doInitialize(ILaunchConfiguration configuration) {
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Map<String, Object> presetToLoad = this.presetToLoad;
        if (presetToLoad != null) {
            this.presetToLoad = null;
            configuration.removeAttribute(this.getValidationErrorAttr());
            LaunchConfigPresets.apply(presetToLoad, configuration);
            this.presetLoaded = configuration;
            return;
        }
        super.performApply(configuration);
    }
}

