/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection.config;

import org.eclipse.statet.ecommons.waltable.config.AbstractRegistryConfiguration;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.style.BasicStyle;
import org.eclipse.statet.ecommons.waltable.core.style.BorderStyle;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class DefaultSelectionStyleConfiguration
extends AbstractRegistryConfiguration {
    public Font selectionFont = GUIHelper.getFont(new FontData("Verdana", 8, 3));
    public Color selectionBgColor = GUIHelper.COLOR_TITLE_INACTIVE_BACKGROUND;
    public Color selectionFgColor = GUIHelper.COLOR_BLACK;
    public Color anchorBorderColor = GUIHelper.COLOR_DARK_GRAY;
    public BorderStyle anchorBorderStyle = new BorderStyle(1, this.anchorBorderColor, BorderStyle.LineStyle.SOLID);
    public Color anchorBgColor = GUIHelper.COLOR_GRAY;
    public Color anchorFgColor = GUIHelper.COLOR_WHITE;
    public Color selectedHeaderBgColor = GUIHelper.COLOR_GRAY;
    public Color selectedHeaderFgColor = GUIHelper.COLOR_WHITE;
    public Font selectedHeaderFont = GUIHelper.getFont(new FontData("Verdana", 10, 1));
    public BorderStyle selectedHeaderBorderStyle = new BorderStyle(-1, this.selectedHeaderFgColor, BorderStyle.LineStyle.SOLID);
    public Color anchorGridBorderColor = GUIHelper.COLOR_BLACK;
    public BorderStyle anchorGridBorderStyle = new BorderStyle(1, this.anchorGridBorderColor, BorderStyle.LineStyle.DOTTED);

    @Override
    public void configureRegistry(ConfigRegistry configRegistry) {
        this.configureSelectionStyle(configRegistry);
        this.configureSelectionAnchorStyle(configRegistry);
        this.configureSelectionAnchorGridLineStyle(configRegistry);
        this.configureHeaderHasSelectionStyle(configRegistry);
        this.configureHeaderFullySelectedStyle(configRegistry);
    }

    protected void configureSelectionStyle(ConfigRegistry configRegistry) {
        BasicStyle cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.FONT, this.selectionFont);
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, this.selectionBgColor);
        cellStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, this.selectionFgColor);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, DisplayMode.SELECTED);
    }

    protected void configureSelectionAnchorStyle(ConfigRegistry configRegistry) {
        BasicStyle cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BORDER_STYLE, this.anchorBorderStyle);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, DisplayMode.NORMAL, "SELECTION_ANCHOR");
        cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, this.anchorBgColor);
        cellStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, this.anchorFgColor);
        cellStyle.setAttributeValue(CellStyling.BORDER_STYLE, this.anchorBorderStyle);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, DisplayMode.SELECTED, "SELECTION_ANCHOR");
    }

    protected void configureSelectionAnchorGridLineStyle(ConfigRegistry configRegistry) {
        BasicStyle cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BORDER_STYLE, this.anchorGridBorderStyle);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, DisplayMode.SELECTED, "selectionAnchorGridLine");
    }

    protected void configureHeaderHasSelectionStyle(ConfigRegistry configRegistry) {
        BasicStyle cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, this.selectedHeaderFgColor);
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, this.selectedHeaderBgColor);
        cellStyle.setAttributeValue(CellStyling.FONT, this.selectedHeaderFont);
        cellStyle.setAttributeValue(CellStyling.BORDER_STYLE, this.selectedHeaderBorderStyle);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, DisplayMode.SELECTED, "COLUMN_HEADER");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, DisplayMode.SELECTED, "CORNER");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, DisplayMode.SELECTED, "ROW_HEADER");
    }

    protected void configureHeaderFullySelectedStyle(ConfigRegistry configRegistry) {
        BasicStyle cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, GUIHelper.COLOR_WIDGET_NORMAL_SHADOW);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, DisplayMode.SELECTED, "COLUMN_HEADER_FULL");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, DisplayMode.SELECTED, "ROW_HEADER_FULL");
    }
}

