/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.core;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.SearchPattern;

@NonNullByDefault
public class DocmlSearchPattern
extends SearchPattern {
    public static final int LABEL_SUBSTRING_MATCH = 0x200000;
    private static final int NOT_CHECKED = -1;
    private static final int NOT_AVAILABLE = -2;
    private int labelPrefixIdx = -1;

    public DocmlSearchPattern(int rules, String pattern) {
        super(rules, pattern);
    }

    public int getSupportedRules() {
        return 2097172;
    }

    protected void onPatternChanged(String pattern) {
        this.labelPrefixIdx = -1;
    }

    private int getLabelPrefixIdx() {
        int labelPrefixIdx = this.labelPrefixIdx;
        if (labelPrefixIdx == -1) {
            labelPrefixIdx = -2;
            char[] patternChars = this.getPatternChars();
            int idx = 0;
            while (idx < patternChars.length) {
                if (patternChars[idx] == ':') {
                    labelPrefixIdx = idx;
                    break;
                }
                ++idx;
            }
            this.labelPrefixIdx = labelPrefixIdx;
        }
        return labelPrefixIdx;
    }

    public int matches(String name) {
        int allowedRules = this.getRules();
        char[] patternChars = null;
        char[] nameChars = null;
        int patternLength = this.getPattern().length();
        int lDiff = name.length() - patternLength;
        if (lDiff >= 0) {
            if ((allowedRules & 4) != 0 && (patternLength == 0 || this.isPrefixMatch(patternChars = this.getPatternChars(), 0, patternChars.length, name, 0, name.length()))) {
                return 4;
            }
            if (lDiff > 0) {
                int labelPrefixIdx;
                if ((allowedRules & 0x200000) != 0 && (labelPrefixIdx = this.getLabelPrefixIdx() + 1) > 0 && this.isPrefixMatch(patternChars = this.getPatternChars(), 0, labelPrefixIdx, nameChars = this.getNameChars(name), 0, name.length()) && this.isSubstringMatch(patternChars, labelPrefixIdx, patternChars.length, nameChars, labelPrefixIdx + 1, nameChars.length)) {
                    return 0x200000;
                }
                if ((allowedRules & 0x10) != 0 && this.isSubstringMatch(patternChars = this.getPatternChars(), 0, patternChars.length, nameChars = this.getNameChars(name), 1, nameChars.length)) {
                    return 16;
                }
            }
        }
        return 0;
    }

    public int @Nullable [] getMatchingRegions(String name, int matchRule) {
        return switch (matchRule) {
            case 0x200000 -> this.getLabelSubstringMatchingRegions(name);
            default -> super.getMatchingRegions(name, matchRule);
        };
    }

    private int[] getLabelSubstringMatchingRegions(String name) {
        int labelPrefixIdx = this.getLabelPrefixIdx() + 1;
        this.tmpRegions.clear();
        this.addPrefixMatch(0, labelPrefixIdx, 0);
        char[] patternChars = this.getPatternChars();
        char[] nameChars = this.getNameChars(name);
        this.addSubstringMatches(patternChars, labelPrefixIdx, patternChars.length, nameChars, labelPrefixIdx + 1, nameChars.length);
        return this.tmpRegions.toArray();
    }
}

